/**
 * JASMINe
 * Copyright (C) 2011-2012 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 */

package org.ow2.jasmine.probe.outers.file.internal;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;

import org.ow2.jasmine.probe.JasmineIndicatorValue;
import org.ow2.jasmine.probe.JasmineOutput;
import org.ow2.jasmine.probe.JasmineProbeResult;
import org.ow2.jasmine.probe.JasmineSingleResult;
import org.ow2.jasmine.probe.outers.JOuter;
import org.ow2.jasmine.probe.util.MetaData;

/**
 * Outer implementation for file.
 * @author durieuxp
 * @author danesa
 */
public class JFileOuter extends JOuter {

    /**
     * file path
     */
    private String path = null;

    /**
     * PrintWriter used to write in the File
     */
    private PrintWriter pw = null;

    /**
     * Constructor
     * @param output definition
     */
    public JFileOuter(JasmineOutput output) {
        super(output);
        // specific part of JasmineOutput (property list)
        Map<String, String> props = output.getProperties();
        this.path = props.get("path");
        File f = new File(path);
        try {
            pw = new PrintWriter(new FileWriter(f), true);
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    /**
     * Flush the Outer.
     */
    @Override
    public void flushData() {
        pw.flush();
    }

    /**
     * Publish data on this Output
     * @param result data to publish
     */
    public void processData(JasmineProbeResult result) {
        for (JasmineIndicatorValue jiv : result.getValues()) {
            // Get server and domain Metadata
            String server = findServer(jiv);
            String domain = findDomain(jiv);
            String target = jiv.getTarget();
            logger.debug("domain=" + domain + " server=" + server + " target=" + target);
            for (JasmineSingleResult jsr : jiv.getValues()) {
                StringBuffer buffer = new StringBuffer();
                // Format must be the same than the one produced by eventswitch:
                // 0 = timestamp
                // 1 = formatted date
                // 2 = target
                // 3 = domain
                // 4 = server
                // 5 = mbean:attr_name
                // 6 = value
                buffer.append(jsr.getTimestamp());
                buffer.append(SEPARATOR);
                buffer.append(dateformat.format(jsr.getTimestamp()));
                buffer.append(SEPARATOR);
                buffer.append(target);
                buffer.append(SEPARATOR);
                buffer.append(domain);
                buffer.append(SEPARATOR);
                buffer.append(server);
                buffer.append(SEPARATOR);
                buffer.append(findMbean(jsr) + ":" + composeName(jiv, jsr.getName()));
                buffer.append(SEPARATOR);
                buffer.append(jsr.getValue());
                pw.println(buffer.toString());
            }
        }
    }

    /**
     * Return the path of the file in which outer publish.
     * Overwrite default (no)location
     */
    public String getPublishLocation() {
        return this.path;
    }
}
