/**
 * JASMINe
 * Copyright (C) 2011 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id$
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.probe.probescheduler;

/**
 * The scheduler service enables to schedule periodic tasks.
 * @author durieuxp
 */
public interface SchedulerService {

    /**
     * Schedules the given task to be performed periodically, after the specified initial delay.
     * @param name task name. (Not used today)
     * @param task the runnable to launch.
     * @param initialDelay given in milliseconds.
     * @param period given in milliseconds.
     * @return the created task reference.
     * @throws SchedulerException if the task cannot be scheduled
     */
    TaskReference schedulePeriodicTask(
            String name,
            Runnable task,
            long initialDelay,
            long period) throws SchedulerException;
}
