/**
 * JASMINe
 * Copyright (C) 2012 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id $
 * --------------------------------------------------------------------------
 */

package org.ow2.jasmine.probe.itests;

import org.ow2.jasmine.probe.JasmineProbeException;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;

public class CnfXmlProcessingIndicatorTest extends AbsProcessingIndicatorTest {

    /*
     * Probe configuration file used for those tests
     */
    private final String probeConfigFileName = "probe-config-processing-indicator.xml";

    @BeforeClass
    public void loadProbeConfigAndWait() throws InterruptedException, JasmineProbeException {
        // load the probe configuration file
        String fName = getConfigurationDirPath().concat(probeConfigFileName);
        try {
            getProxyMXBean().loadConfig(fName);
        } catch (Exception e) {
            Assert.fail("Cannot load the probe config file '" + fName + "'", e);
        }
        logger.info("The probe configuration '" + fName +"' successfully loaded");

        // Wait few mn to get the time to do some collects .... and than stop all the probes
        logger.info("Wait " + WAIT_COLLECTS_IN_SEC + " sec to get time to do some collects ...");
        Thread.sleep(WAIT_COLLECTS_IN_SEC*1000);
        getProxyMXBean().stopAllProbes();
    }

}
