/**
 * JASMINe
 * Copyright (C) 2012 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id$
 * --------------------------------------------------------------------------
 */

package org.ow2.jasmine.probe.itests.rest;

import java.io.File;

import com.sun.jersey.api.client.Client;

import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeSuite;

public class AbsRestTest {

    /**
     * Logger used for REST tests.
     */
    protected static Log logger = LogFactory.getLog(AbsRestTest.class);
    
    /**
     * Web container port number
     */
    protected static final String webcontainerPort =  System.getProperty("webcontainer.port", "9000");

    /**
     * URL base of the jasmine-probe API REST
     */
    protected static final String urlBase = "http://localhost:"+webcontainerPort+"/jprobe";
    
    /**
     * tmp directory path for output files
     */
    protected static final String tmpDirPath =  System.getProperty("java.io.tmp") + File.separator;
    
    /**
     * REST client
     */
    protected Client restClient = null;

    /**
     * The waiting time to get time to do some collects
     */
    private static final int WAIT_COLLECTS_IN_SEC = 80;

    /**
     * Setup method for the REST tests of get methods.
     * - Wait a while to get the time to do some collects.
     * Do that only once for all the tests of the suite
     */
    @BeforeSuite
    public void waitCollects()  throws InterruptedException{
        // Wait a while to get the time to do some collects 
        logger.info("Wait " + WAIT_COLLECTS_IN_SEC + " sec. to get time to do some collects...");
        Thread.sleep(WAIT_COLLECTS_IN_SEC*1000);
    }

    /**
     * Setup method for the REST tests.
     * - Wait a while to get the time to do some collects.
     * - Creation of the REST Client.
     */
    @BeforeClass
    public void createRestClient() {
        // Creation of the REST Client
        restClient = Client.create();
    }
}
