/**
 * JASMINe
 * Copyright (C) 2012 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id$
 * --------------------------------------------------------------------------
 */

package org.ow2.jasmine.probe.itests.rest;

import java.io.File;
import java.net.HttpURLConnection;

import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;

import org.testng.Assert;
import org.testng.annotations.Test;

public class CreateDeleteTest extends AbsRestTest {

    /**
     * Create an output file
     */
    @Test
    public void createOutputFileOne() throws Exception {
        WebResource webResource;
        ClientResponse response;
        
        // Create the output file
        String input = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\" ?><output xmlns=\"org.ow2.jasmine.probe:probe-config\" name=\"otst_file_ONE\" type=\"file\"><property key=\"path\" value=\""+tmpDirPath+"log_ONE.csv\"/></output>";
        String sUri = urlBase + "/output";
        logger.info("Resource URI: " + sUri);
        webResource = restClient.resource(sUri);
        response = webResource.type("application/xml").post(ClientResponse.class, input);
        // Check the status of the request
        Assert.assertEquals(response.getStatus(), HttpURLConnection.HTTP_OK, "Bad HTTP status when creating");
        
        // Check the created output
        sUri = urlBase + "/output/otst_file_ONE";
        logger.info("Resource URI: " + sUri);
        webResource = restClient.resource(sUri);
        response = webResource.get(ClientResponse.class);
        // Check the status of the request
        Assert.assertEquals(response.getStatus(), HttpURLConnection.HTTP_OK, "Bad HTTP status when getting");
    }

    /**
     * Try to create an already existing output
     */
    // TODO
    //@Test (dependsOnMethods={"createOutputFileOne"})
    public void createExistingOutput() throws Exception {
        WebResource webResource;
        ClientResponse response;
        
        // Try to create an existing output
        String input = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\" ?><output xmlns=\"org.ow2.jasmine.probe:probe-config\" name=\"otst_file_ONE\" type=\"file\"><property key=\"path\" value=\""+tmpDirPath+"log_ONE_BIS.csv\"/></output>";
        String sUri = urlBase + "/output";
        logger.info("Resource URI: " + sUri);
        webResource = restClient.resource(sUri);
        response = webResource.type("application/xml").post(ClientResponse.class, input);
        // Check the status of the request
        Assert.assertEquals(response.getStatus(), HttpURLConnection.HTTP_BAD_REQUEST, "Bad HTTP status");
    }

    /**
     * Create an indicator constant
     */
    @Test
    public void createIndicatorConstantOne() throws Exception {
        WebResource webResource;
        ClientResponse response;
        
        // Create the indicator constant
        String input = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\" ?><indicator xmlns=\"org.ow2.jasmine.probe:probe-config\" name=\"C_ONE\" type=\"constant\"><property key=\"value\" value=\"1\"/><property key=\"type\" value=\"int\"/></indicator>";
        String sUri = urlBase + "/indicator";
        logger.info("Resource URI: " + sUri);
        webResource = restClient.resource(sUri);
        response = webResource.type("application/xml").post(ClientResponse.class, input);
        // Check the status of the request
        Assert.assertEquals(response.getStatus(), HttpURLConnection.HTTP_OK, "Bad HTTP status when creating");
        
        // Check the created indicator
        sUri = urlBase + "/indicator/C_ONE";
        logger.info("Resource URI: " + sUri);
        webResource = restClient.resource(sUri);
        response = webResource.get(ClientResponse.class);
        // Check the status of the request
        Assert.assertEquals(response.getStatus(), HttpURLConnection.HTTP_OK, "Bad HTTP status when getting");
    }

    /**
     * Try to create an existing indicator
     */
    // TODO
    //@Test (dependsOnMethods={"createIndicatorConstantOne"})
    public void createExistingIndicator() throws Exception {
        WebResource webResource;
        ClientResponse response;
        
        // Try to create an existing indicator
        String input = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\" ?><indicator xmlns=\"org.ow2.jasmine.probe:probe-config\" name=\"C_ONE\" type=\"constant\"><property key=\"value\" value=\"1\"/><property key=\"type\" value=\"int\"/></indicator>";
        String sUri = urlBase + "/indicator";
        logger.info("Resource URI: " + sUri);
        webResource = restClient.resource(sUri);
        response = webResource.type("application/xml").post(ClientResponse.class, input);
        // Check the status of the request
        Assert.assertEquals(response.getStatus(), HttpURLConnection.HTTP_BAD_REQUEST, "Bad HTTP status");
    }

    /**
     * Create an probe
     */
    @Test (dependsOnMethods={"createOutputFileOne", "createIndicatorConstantOne"})
    public void createProbeOne() throws Exception {
        WebResource webResource;
        ClientResponse response;
        
        // Create a simple probe
        String input = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\" ?><probe xmlns=\"org.ow2.jasmine.probe:probe-config\" period=\"5\" status=\"started\" id=\"probe_ONE\"><indicator>C_ONE</indicator><output>otst_file_ONE</output></probe>";
        String sUri = urlBase + "/probe";
        logger.info("Resource URI: " + sUri);
        webResource = restClient.resource(sUri);
        response = webResource.type("application/xml").post(ClientResponse.class, input);
        // Check the status of the request
        Assert.assertEquals(response.getStatus(), HttpURLConnection.HTTP_ACCEPTED, "Bad HTTP status when creating");
        
        // Check the created probe
        sUri = urlBase + "/probe/probe_ONE";
        logger.info("Resource URI: " + sUri);
        webResource = restClient.resource(sUri);
        response = webResource.get(ClientResponse.class);
        // Check the status of the request
        Assert.assertEquals(response.getStatus(), HttpURLConnection.HTTP_OK, "Bad HTTP status when checking");
        
        // Check some collects are done
        logger.info("Wait a while to get time to do some collects ...");
        Thread.sleep(29*1000);
        String fNameOutput = tmpDirPath + "log_ONE.csv";
        File fOutput = new File(fNameOutput);
        Assert.assertFalse(fOutput.length() == 0, "Output file for 'probe_ONE' probe not exist or empty ("+fNameOutput+")");
    }
    
    /**
     * Try to create an existing probe
     */
    @Test (dependsOnMethods={"createProbeOne"})
    public void createExistingProbe() throws Exception {
        WebResource webResource;
        ClientResponse response;
        
        // Try to create an existing probe
        String input = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\" ?><probe xmlns=\"org.ow2.jasmine.probe:probe-config\" period=\"5\" status=\"started\" id=\"probe_ONE\"><indicator>C_ONE</indicator><output>otst_file_ONE</output></probe>";
        String sUri = urlBase + "/probe";
        logger.info("Resource URI: " + sUri);
        webResource = restClient.resource(sUri);
        response = webResource.type("application/xml").post(ClientResponse.class, input);
        // Check the status of the request
        Assert.assertEquals(response.getStatus(), HttpURLConnection.HTTP_BAD_REQUEST, "Bad HTTP status");
    }
    
    /**
     * Delete a probe
     */
    @Test (dependsOnMethods={"createProbeOne"})
    public void deleteProbe() throws Exception {
        WebResource webResource;
        ClientResponse response;
        
        // Delete a probe
        String sUri = urlBase + "/probe/probe_ONE";
        logger.info("Resource URI: " + sUri);
        webResource = restClient.resource(sUri);
        response = webResource.delete(ClientResponse.class);
        // Check the status of the request
        Assert.assertEquals(response.getStatus(), HttpURLConnection.HTTP_OK, "Bad HTTP status");
        
        // Check the probe no more exist
        sUri = urlBase + "/probe/probe_ONE";
        logger.info("Resource URI: " + sUri);
        webResource = restClient.resource(sUri);
        response = webResource.get(ClientResponse.class);
        // Check the status of the request
        Assert.assertEquals(response.getStatus(), HttpURLConnection.HTTP_NOT_FOUND, "Bad HTTP status when checking");
    }
    
    /**
     * Try to delete an unknown probe
     */
    @Test
    public void deleteUnknownProbe() throws Exception {
        WebResource webResource;
        ClientResponse response;
        
        // Try to delete an unknown probe
        String sUri = urlBase + "/probe/unknown";
        logger.info("Resource URI: " + sUri);
        webResource = restClient.resource(sUri);
        response = webResource.delete(ClientResponse.class);
        // Check the status of the request
        Assert.assertEquals(response.getStatus(), HttpURLConnection.HTTP_NOT_FOUND, "Bad HTTP status");
    }

    /**
     * Delete an indicator
     */
    @Test (dependsOnMethods={"deleteProbe"})
    public void deleteIndicator() throws Exception {
        WebResource webResource;
        ClientResponse response;
        
        // Delete an indicator
        String sUri = urlBase + "/indicator/C_ONE";
        logger.info("Resource URI: " + sUri);
        webResource = restClient.resource(sUri);
        response = webResource.delete(ClientResponse.class);
        // Check the status of the request
        Assert.assertEquals(response.getStatus(), HttpURLConnection.HTTP_OK, "Bad HTTP status");
        
        // Check the indicator no more exist
        sUri = urlBase + "/indicator/C_ONE";
        logger.info("Resource URI: " + sUri);
        webResource = restClient.resource(sUri);
        response = webResource.get(ClientResponse.class);
        // Check the status of the request
        Assert.assertEquals(response.getStatus(), HttpURLConnection.HTTP_NOT_FOUND, "Bad HTTP status when checking");
    }

    /**
     * Try to delete an unknown indicator
     */
    @Test
    public void deleteUnknownIndicator() throws Exception {
        WebResource webResource;
        ClientResponse response;
        
        // Try to delete an unknown indicator
        String sUri = urlBase + "/indicator/unknown";
        logger.info("Resource URI: " + sUri);
        webResource = restClient.resource(sUri);
        response = webResource.delete(ClientResponse.class);
        // Check the status of the request
        Assert.assertEquals(response.getStatus(), HttpURLConnection.HTTP_NOT_FOUND, "Bad HTTP status");
    }
    
    /**
     * Delete an output
     */
    @Test (dependsOnMethods={"deleteProbe"})
    public void deleteOutput() throws Exception {
        WebResource webResource;
        ClientResponse response;
        
        // Delete an output
        String sUri = urlBase + "/output/otst_file_ONE";
        logger.info("Resource URI: " + sUri);
        webResource = restClient.resource(sUri);
        response = webResource.delete(ClientResponse.class);
        // Check the status of the request
        Assert.assertEquals(response.getStatus(), HttpURLConnection.HTTP_OK, "Bad HTTP status");
        
        // Check the output no more exist
        sUri = urlBase + "/output/otst_file_ONE";
        logger.info("Resource URI: " + sUri);
        webResource = restClient.resource(sUri);
        response = webResource.get(ClientResponse.class);
        // Check the status of the request
        Assert.assertEquals(response.getStatus(), HttpURLConnection.HTTP_NOT_FOUND, "Bad HTTP status when checking");
    }
    
    /**
     * Try to delete an unknown output
     */
    @Test
    public void deleteUnknownOutput() throws Exception {
        WebResource webResource;
        ClientResponse response;
        
        // Try to delete an unknown output
        String sUri = urlBase + "/output/unknown";
        logger.info("Resource URI: " + sUri);
        webResource = restClient.resource(sUri);
        response = webResource.delete(ClientResponse.class);
        // Check the status of the request
        Assert.assertEquals(response.getStatus(), HttpURLConnection.HTTP_NOT_FOUND, "Bad HTTP status");
    }

    /**
     * Create an invalid probe, (indicator not exist). with the status started. The probe is created, but its status is failed.
     * Delete this invalid created probe
     */
    @Test
    public void createInvalidProbe() throws Exception {
        WebResource webResource;
        ClientResponse response;
        
        // Try to create an invalid probe: indicator not exist
        String input = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\" ?><probe xmlns=\"org.ow2.jasmine.probe:probe-config\" period=\"5\" status=\"started\" id=\"probe_INVALID\"><indicator>unknown</indicator><output>stdio1</output></probe>";
        String sUri = urlBase + "/probe";
        logger.info("Resource URI: " + sUri);
        webResource = restClient.resource(sUri);
        response = webResource.type("application/xml").post(ClientResponse.class, input);
        // Check the status of the request
        Assert.assertEquals(response.getStatus(), HttpURLConnection.HTTP_BAD_REQUEST, "Bad HTTP status when creating");
        
        // Delete the created probe
        sUri = urlBase + "/probe/probe_INVALID";
        logger.info("Resource URI: " + sUri);
        webResource = restClient.resource(sUri);
        response = webResource.delete(ClientResponse.class);
        // Check the status of the request
        Assert.assertEquals(response.getStatus(), HttpURLConnection.HTTP_OK, "Bad HTTP status when deleting");
        
    }

}
