package org.ow2.jasmine.probe;

import java.util.List;

/**
 * Information about this Inidcator type (the Collector)
 * @author durieuxp
 */
public class JasmineCollectorInfo {

    /**
     * Empty constructor
     */
    public JasmineCollectorInfo() {
    }

    /**
     * type name
     */
    private String type;

    /**
     * short Description of this type
     */
    private String shortDesc;

    /**
     * long Description of this type
     */
    private String longDesc;

    /**
     * Description of the source indicators, if any
     */
    private String sourceDesc;

    /**
     * Min nb of source Indicators
     */
    private int sourceMin;

    /**
     * Max nb of source Indicators
     */
    private int sourceMax;

    /**
     * Information about valid properties for this type.
     */
    private List<JasminePropertyInfo> propertyInfos;

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getShortDesc() {
        return shortDesc;
    }

    public void setShortDesc(String shortDesc) {
        this.shortDesc = shortDesc;
    }

    public String getLongDesc() {
        return longDesc;
    }

    public void setLongDesc(String longDesc) {
        this.longDesc = longDesc;
    }

    public String getSourceDesc() {
        return sourceDesc;
    }

    public void setSourceDesc(String sourceDesc) {
        this.sourceDesc = sourceDesc;
    }

    public int getSourceMin() {
        return sourceMin;
    }

    public void setSourceMin(int sourceMin) {
        this.sourceMin = sourceMin;
    }

    public int getSourceMax() {
        return sourceMax;
    }

    public void setSourceMax(int sourceMax) {
        this.sourceMax = sourceMax;
    }

    public List<JasminePropertyInfo> getPropertyInfos() {
        return propertyInfos;
    }

    public void setPropertyInfos(List<JasminePropertyInfo> propertyInfos) {
        this.propertyInfos = propertyInfos;
    }
}
