/**
 * JASMINe
 * Copyright (C) 2012 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id$
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.probe.rest.impl;

import java.util.HashSet;
import java.util.Set;

import javax.ws.rs.core.Application;

import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.Invalidate;
import org.apache.felix.ipojo.annotations.Provides;
import org.apache.felix.ipojo.annotations.Requires;
import org.apache.felix.ipojo.annotations.ServiceProperty;
import org.apache.felix.ipojo.annotations.Validate;
import org.ow2.jasmine.probe.JasmineProbeManager;
import org.ow2.jasmine.probe.rest.TasksManager;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/**
 * REST application that implements REST service for JasmineProbe.
 * The application instance is to be wrapped by a servlet.
 *
 * @author danesa
 *
*/
@Component(name="JasmineProbeRSApp", immediate = true)
@Provides(specifications={javax.ws.rs.core.Application.class})
public class JPRSApplication extends Application {

    private Log logger = LogFactory.getLog(this.getClass());

    /**
     * JasmineProbeManager is used to create JasmineProbe artifacts, to start/stop probes, etc.
     */
    @Requires
    private JasmineProbeManager jpManager;

    /**
     * The TaskManager used to create data tasks.
     */
    @Requires(optional=true)
    private TasksManager tasksManager;

    @ServiceProperty(name="jonas.jaxrs.context-path", value="/jprobe")
    private String jpContextName;

    public JPRSApplication() {
    }

    @Override
    public Set<Class<?>> getClasses() {
        return null;
    }

    /**
     * Register resource implementation classes.
     */
    @Override
    public Set<Object> getSingletons() {
        logger.debug("");
        Set<Object> objects = new HashSet<Object>();
        objects.add(new JProbes(jpManager, tasksManager));
        objects.add(new JIndicators(jpManager));
        objects.add(new JOutputs(jpManager));
        objects.add(new JTargets(jpManager));
        objects.add(new JIndicatorTypes(jpManager));
        objects.add(new JOutputTypes(jpManager));
        objects.add(new JDataTasks(tasksManager));
        return objects;
    }

    @Validate
    public void start() {
        logger.debug("");
    }


    @Invalidate
    public void stop() {
        logger.debug("");
    }
}
