/**
 * JASMINe
 * Copyright (C) 2012 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id$
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.probe.rest.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.Provides;
import org.ow2.jasmine.probe.rest.Task;
import org.ow2.jasmine.probe.rest.Tasks;
import org.ow2.jasmine.probe.rest.TasksManager;

@Component(name = "TasksManagerService")
@Provides
public class JTasksManager implements TasksManager {

    Map<String, JTask> tasks = new HashMap<String, JTask>();

    /**
     * Create a data task for a probe. If already created, return its id.
     * Used in JProbes as a treatment for POST /probe/{probeId}/data.
     * @param probeId the probe's id
     * @return task id
     */
    @Override
    public synchronized String createTask(String probeId) {
        // TEMPORARY
        // ---------
        // Use the probe id as task id as only one data task
        // is supported for a probe currently !
        //
        String taskId = probeId;
        if (!tasks.containsKey(probeId)) {
            // create task
            JTask task = new JTask(probeId, taskId);
            Tasks.logger.debug("Task created with id {0} for probe {1}", taskId, probeId);
            tasks.put(taskId, task);
        }
        return taskId;
    }

    /**
     * Get a task object
     * @param taskId the task's id
     * @return the task object's reference or null if no task having the given id
     */
    @Override
    public synchronized Task getTask(String taskId) {
        return tasks.get(taskId);
    }

    /**
     * @return the list of the tasks ids
     */
    @Override
    public synchronized List<String> getTasks() {
        List<String> taskIds = new ArrayList<String>(tasks.keySet());
        return taskIds;
    }

    @Override
    public void removeTask(String taskId) {
        tasks.remove(taskId);
    }
}
