/**
 * JASMINe
 * Copyright (C) 2011 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id$
 * --------------------------------------------------------------------------
 */

package org.ow2.jasmine.probe.probescheduler.jonas;

import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.Invalidate;
import org.apache.felix.ipojo.annotations.Provides;
import org.apache.felix.ipojo.annotations.Validate;
import org.ow2.jasmine.probe.probescheduler.*;
import org.ow2.jonas.lib.timer.TimerEvent;
import org.ow2.jonas.lib.timer.TimerEventListener;
import org.ow2.jonas.lib.timer.TimerManager;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/**
 * This simple implementation is based on the jonas timers.
 * @author durieuxp
 */
@Component(name="JasmineJonasScheduler")
@Provides
public class SimpleScheduler implements SchedulerService {

    private TimerManager timerMgr;

    private Log logger = LogFactory.getLog(SchedulerService.class);

    /**
     * Start the ipojo
     */
    @Validate
    public void start() {
        logger.debug("");
        timerMgr = TimerManager.getInstance();
    }

    /**
     * Stop the ipojo
     */
    @Invalidate
    public void stop() {
        logger.debug("");
    }

    /**
     * Register a Job
     * @param period millisec
     */
    public TaskReference schedulePeriodicTask(
            String name,
            Runnable task,
            long initialDelay,
            long period) throws SchedulerException {
        logger.debug("");
        TimerEventListener tel = new ListenerWrapper(task);
        TimerEvent timer = timerMgr.addTimerMs(tel, period, null, true);
        return new TimerEventWrapper(timer);

    }
}
