#set( $symbol_pound = '#' )
#set( $symbol_dollar = '$' )
#set( $symbol_escape = '\' )
package ${package};

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;

import org.ow2.jasmine.probe.JasmineIndicatorValue;
import org.ow2.jasmine.probe.JasmineOutput;
import org.ow2.jasmine.probe.JasmineProbeResult;
import org.ow2.jasmine.probe.JasmineSingleResult;
import org.ow2.jasmine.probe.outers.JOuter;
import org.ow2.jasmine.probe.util.MetaData;

/**
 * Outer implementation for ...
 */
public class TemplateOuter extends JOuter {

    /**
     * Constructor
     * @param output definition
     */
    public TemplateOuter(JasmineOutput output) {
        super(output);
        // specific part of JasmineOutput (property list)
        Map<String, String> props = output.getProperties();
    }

    /**
     * Publish data on this Output
     * @param result data to publish
     */
    public void processData(JasmineProbeResult result) {
        for (JasmineIndicatorValue jiv : result.getValues()) {
            // Get server and domain Metadata
            String server = findServer(jiv);
            String domain = findDomain(jiv);
            String target = jiv.getTarget();
            logger.debug("domain=" + domain + " server=" + server + " target=" + target);
            for (JasmineSingleResult jsr : jiv.getValues()) {
                StringBuffer buffer = new StringBuffer();
                // Format must be the same than the one produced by eventswitch:
                // 0 = timestamp
                // 1 = formatted date
                // 2 = target
                // 3 = domain
                // 4 = server
                // 5 = mbean:attr_name
                // 6 = value
                buffer.append(jsr.getTimestamp());
                buffer.append(SEPARATOR);
                buffer.append(dateformat.format(jsr.getTimestamp()));
                buffer.append(SEPARATOR);
                buffer.append(target);
                buffer.append(SEPARATOR);
                buffer.append(domain);
                buffer.append(SEPARATOR);
                buffer.append(server);
                buffer.append(SEPARATOR);
                buffer.append(findMbean(jsr) + ":" + composeName(jiv, jsr.getName()));
                buffer.append(SEPARATOR);
                buffer.append(jsr.getValue());

                System.out.println(buffer.toString());
            }
        }
    }

}
