/**
 * JASMINe
 * Copyright (C) 2011 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id$
 * --------------------------------------------------------------------------
 */


package org.ow2.jasmine.probe.itests;

import java.io.FileReader;
import java.util.ArrayList;

import org.testng.Assert;
import org.testng.annotations.Test;

import au.com.bytecode.opencsv.CSVReader;

public abstract class AbsStructuredAttrIndicatorTest extends JOnASLauncher {

    /*
     * The waiting time to get time to do some collects
     */
    static final int WAIT_COLLECTS_IN_SEC = 20;

    /**
     * Check the collects corresponding to the ptst1_Logging_SomeLoggerNames probe.
     * The LoggerNames attribute type is java.lang.String[].
     */
    @Test
    public void testLoggingSomeLoggerNames() throws Exception {
        logger.debug(">> testLoggingSomeLoggerNames");
        String fName = getTmpDirPath() + "tst1_Logging_SomeLoggerNames.csv";
        CSVReader reader = null;
        boolean emptyOutput0 = true;
        boolean emptyOutput3 = true;
        try {
            reader = new CSVReader(new FileReader(fName), ';');
            String[] nextLine;
            String indicatorName;
            while ((nextLine = reader.readNext()) != null) {
                // nextLine[] is an array of values from the line
                indicatorName = Util.getNameOfFullName(nextLine[Util.CSV_INDEX_NAME]);
                if ("tst1_Logging_SomeLoggerNames.LoggerNames[0]".equals(indicatorName)) {
                    emptyOutput0 = false;
                } else if ("tst1_Logging_SomeLoggerNames.LoggerNames[3]".equals(indicatorName)) {
                    emptyOutput3 = false;
                } else {
                    Assert.fail("The '" + indicatorName + "' indicator shoud not be collected !");
                }
            }
        } finally {
            if (reader != null) {
                reader.close();
            }
        }
        Assert.assertFalse(emptyOutput0, "There is no collects for LoggerNames[0] in the output " + fName);
        Assert.assertFalse(emptyOutput3, "There is no collects for LoggerNames[3] in the output " + fName);
    }

    /**
     * Check the collects corresponding to the ptst1_Threading_SomeThreadIds probe.
     * The AllThreadIds attribute type is long[]
     */
    @Test
    public void testThreadingSomeThreadIds() throws Exception {
        logger.debug(">> testThreadingSomeThreadIds");
        String fName = getTmpDirPath() + "tst1_Threading_SomeThreadIds.csv";
        CSVReader reader = null;
        boolean emptyOutput0 = true;
        boolean emptyOutput5 = true;
        try {
            reader = new CSVReader(new FileReader(fName), ';');
            String[] nextLine;
            String indicatorName;
            while ((nextLine = reader.readNext()) != null) {
                // nextLine[] is an array of values from the line
                indicatorName = Util.getNameOfFullName(nextLine[Util.CSV_INDEX_NAME]);
                if ("tst1_Threading_SomeThreadIds.AllThreadIds[0]".equals(indicatorName)) {
                    emptyOutput0 = false;
                } else if ("tst1_Threading_SomeThreadIds.AllThreadIds[5]".equals(indicatorName)) {
                    emptyOutput5 = false;
                } else {
                    Assert.fail("The '" + indicatorName + "' indicator shoud not be collected !");
                }
            }
        } finally {
            if (reader != null) {
                reader.close();
            }
        }
        Assert.assertFalse(emptyOutput0, "There is no collects for AllThreadIds[0] in the output " + fName);
        Assert.assertFalse(emptyOutput5, "There is no collects for AllThreadIds[3] in the output " + fName);
    }

    /**
     * Check the collects corresponding to the ptst1_Memory_XMemoryUsage_used probe.
     * The XMemoryUsage type is a composite data.
     */
    @Test
    public void testMemoryUsageUsed() throws Exception {
        logger.debug(">> testMemoryUsageUsed");
        String fName = getTmpDirPath() + "tst1_Memory_XMemoryUsage_used.csv";
        CSVReader reader = null;
        boolean emptyOutputHeap = true;
        boolean emptyOutputNonHeap = true;
        try {
            reader = new CSVReader(new FileReader(fName), ';');
            String[] nextLine;
            String indicatorName;
            while ((nextLine = reader.readNext()) != null) {
                // nextLine[] is an array of values from the line
                indicatorName = Util.getNameOfFullName(nextLine[Util.CSV_INDEX_NAME]);
                if ("tst1_Memory_XMemoryUsage_used.HeapMemoryUsage.used".equals(indicatorName)) {
                    emptyOutputHeap = false;
                } else if ("tst1_Memory_XMemoryUsage_used.NonHeapMemoryUsage.used".equals(indicatorName)) {
                    emptyOutputNonHeap = false;
                } else {
                    Assert.fail("The '" + indicatorName + "' indicator shoud not be collected !");
                }
            }
        } finally {
            if (reader != null) {
                reader.close();
            }
        }
        Assert.assertFalse(emptyOutputHeap, "There is no collects for HeapMemoryUsage in the output " + fName);
        Assert.assertFalse(emptyOutputNonHeap, "There is no collects for NonHeapMemoryUsage in the output " + fName);
    }

    /**
     * Check the collects corresponding to the ptst1_Runtime_SystemProperties_jonas_name_value probe.
     * The SystemProperties attribute type is a tabular data.
     */
    @Test
    public void testRuntimeSystemPropertiesJonasName() throws Exception {
        logger.debug(">> testRuntimeSystemPropertiesJonasName");
        String fName = getTmpDirPath() + "tst1_Runtime_SystemProperties_jonas_name_value.csv";
        CSVReader reader = null;
        boolean emptyOutput = true;
        try {
            reader = new CSVReader(new FileReader(fName), ';');
            String[] nextLine;
            String indicatorName;
            String value;
            while ((nextLine = reader.readNext()) != null) {
                // nextLine[] is an array of values from the line
                indicatorName = Util.getNameOfFullName(nextLine[Util.CSV_INDEX_NAME]);
                value = nextLine[Util.CSV_INDEX_VALUE];
                if ("tst1_Runtime_SystemProperties_jonas_name_value".equals(indicatorName)) {
                    emptyOutput = false;
                    Assert.assertEquals(value, "jasmine-probe", "Invalid 'tst1_Runtime_SystemProperties_jonas_name_value' value !");
                } else {
                    Assert.fail("The '" + indicatorName + "' indicator shoud not be collected !");
                }
            }
        } finally {
            if (reader != null) {
                reader.close();
            }
        }
        Assert.assertFalse(emptyOutput, "There is no collects in the output " + fName);
    }

    /**
     * Check the collects corresponding to the ptst1_Complex_hjo probe.
     */
    @Test
    public void testComplexHjo() throws Exception {
        logger.debug(">> testComplexHjo");
        String fName = getTmpDirPath() + "tst1_Complex_hjo.csv";
        CSVReader reader = null;
        boolean emptyOutput = true;
        ArrayList<String> actualsIndicators = new ArrayList<String>();
        ArrayList<String> expectedIndicators = new ArrayList<String>();
        expectedIndicators.add("tst1_Complex_hjo.StringArray[0]");
        expectedIndicators.add("tst1_Complex_hjo.StringArray[1]");
        expectedIndicators.add("tst1_Complex_hjo.LongArrayOneElt[0]");
        expectedIndicators.add("tst1_Complex_hjo.StructOneField.field1");
        expectedIndicators.add("tst1_Complex_hjo.Person.firstName");
        expectedIndicators.add("tst1_Complex_hjo.Person.lastName");
        expectedIndicators.add("tst1_Complex_hjo.Person.sexe");
        expectedIndicators.add("tst1_Complex_hjo.Person.yearOfBirth");
        expectedIndicators.add("tst1_Complex_hjo.Person.address.addr");
        expectedIndicators.add("tst1_Complex_hjo.Person.address.city");
        expectedIndicators.add("tst1_Complex_hjo.Person.address.code");
        expectedIndicators.add("tst1_Complex_hjo.Person.children[0]");
        expectedIndicators.add("tst1_Complex_hjo.Person.children[1]");
        expectedIndicators.add("tst1_Complex_hjo.IntArray[0]");
        expectedIndicators.add("tst1_Complex_hjo.IntArray[1]");
        expectedIndicators.add("tst1_Complex_hjo.IntArray[2]");
        expectedIndicators.add("tst1_Complex_hjo.TabularSimple[lastName].key");
        expectedIndicators.add("tst1_Complex_hjo.TabularSimple[lastName].value");
        expectedIndicators.add("tst1_Complex_hjo.TabularSimple[firstName].key");
        expectedIndicators.add("tst1_Complex_hjo.TabularSimple[firstName].value");
        try {
            reader = new CSVReader(new FileReader(fName), ';');
            String[] nextLine;
            String indicatorName;
            String value;
            while ((nextLine = reader.readNext()) != null) {
                // nextLine[] is an array of values from the line
                indicatorName = Util.getNameOfFullName(nextLine[Util.CSV_INDEX_NAME]);
                value = nextLine[Util.CSV_INDEX_VALUE];
                emptyOutput = false;
                if ("tst1_Complex_hjo.StringArray[0]".equals(indicatorName)) {
                    actualsIndicators.add(indicatorName);
                    Assert.assertEquals(value, "Helene", "Invalid 'tst1_Complex_hjo.StringArray[0]' value !");
                } else if ("tst1_Complex_hjo.StringArray[1]".equals(indicatorName)) {
                    actualsIndicators.add(indicatorName);
                    Assert.assertEquals(value, "des Bois", "Invalid 'tst1_Complex_hjo.StringArray[1]' value !");
                } else if ("tst1_Complex_hjo.LongArrayOneElt[0]".equals(indicatorName)) {
                    actualsIndicators.add(indicatorName);
                   Assert.assertEquals(Integer.parseInt(value), 1001959, "Invalid 'tst1_Complex_hjo.LongArrayOneElt[0]' value !");
                } else if ("tst1_Complex_hjo.StructOneField.field1".equals(indicatorName)) {
                   actualsIndicators.add(indicatorName);
                   Assert.assertEquals(value, "Helene des Bois", "Invalid 'tst1_Complex_hjo.StructOneField.field1' value !");
                } else if ("tst1_Complex_hjo.Person.firstName".equals(indicatorName)) {
                    actualsIndicators.add(indicatorName);
                    Assert.assertEquals(value, "Helene", "Invalid 'tst1_Complex_hjo.Person.firstName' value !");
                } else if ("tst1_Complex_hjo.Person.lastName".equals(indicatorName)) {
                    actualsIndicators.add(indicatorName);
                    Assert.assertEquals(value, "des Bois", "Invalid 'tst1_Complex_hjo.Person.lastName' value !");
                } else if ("tst1_Complex_hjo.Person.sexe".equals(indicatorName)) {
                    actualsIndicators.add(indicatorName);
                    Assert.assertEquals(value, "FEMALE", "Invalid 'tst1_Complex_hjo.Person.sexe' value !");
                } else if ("tst1_Complex_hjo.Person.yearOfBirth".equals(indicatorName)) {
                    actualsIndicators.add(indicatorName);
                    Assert.assertEquals(value, "1959", "Invalid 'tst1_Complex_hjo.Person.yearOfBirth' value !");
                } else if ("tst1_Complex_hjo.Person.address.addr".equals(indicatorName)) {
                    actualsIndicators.add(indicatorName);
                    Assert.assertEquals(value, "rue Principale", "Invalid 'tst1_Complex_hjo.Person.address.addr' value !");
                } else if ("tst1_Complex_hjo.Person.address.city".equals(indicatorName)) {
                    actualsIndicators.add(indicatorName);
                    Assert.assertEquals(value, "SMH", "Invalid 'tst1_Complex_hjo.Person.address.city' value !");
                } else if ("tst1_Complex_hjo.Person.address.code".equals(indicatorName)) {
                    actualsIndicators.add(indicatorName);
                    Assert.assertEquals(value, "38400", "Invalid 'tst1_Complex_hjo.Person.address.code' value !");
                } else if ("tst1_Complex_hjo.Person.children[0]".equals(indicatorName)) {
                    actualsIndicators.add(indicatorName);
                    Assert.assertEquals(value, "1987", "Invalid 'tst1_Complex_hjo.Person.children[0]' value !");
                } else if ("tst1_Complex_hjo.Person.children[1]".equals(indicatorName)) {
                    actualsIndicators.add(indicatorName);
                    Assert.assertEquals(value, "1990", "Invalid 'tst1_Complex_hjo.Person.children[1]' value !");
                } else if ("tst1_Complex_hjo.IntArray[0]".equals(indicatorName)) {
                    actualsIndicators.add(indicatorName);
                    Assert.assertEquals(value, "1959", "Invalid 'tst1_Complex_hjo.IntArray[0]' value !");
                } else if ("tst1_Complex_hjo.IntArray[1]".equals(indicatorName)) {
                    actualsIndicators.add(indicatorName);
                    Assert.assertEquals(value, "2959", "Invalid 'tst1_Complex_hjo.IntArray[1]' value !");
                } else if ("tst1_Complex_hjo.IntArray[2]".equals(indicatorName)) {
                    actualsIndicators.add(indicatorName);
                    Assert.assertEquals(value, "3959", "Invalid 'tst1_Complex_hjo.IntArray[2]' value !");
                } else if ("tst1_Complex_hjo.TabularSimple[lastName].key".equals(indicatorName)) {
                    actualsIndicators.add(indicatorName);
                    Assert.assertEquals(value, "lastName", "Invalid 'tst1_Complex_hjo.TabularSimple[lastName].key' value !");
                } else if ("tst1_Complex_hjo.TabularSimple[lastName].value".equals(indicatorName)) {
                    actualsIndicators.add(indicatorName);
                    Assert.assertEquals(value, "des Bois", "Invalid 'tst1_Complex_hjo.TabularSimple[lastName].value' value !");
                } else if ("tst1_Complex_hjo.TabularSimple[firstName].key".equals(indicatorName)) {
                    actualsIndicators.add(indicatorName);
                    Assert.assertEquals(value, "firstName", "Invalid 'tst1_Complex_hjo.TabularSimple[firstName].key' value !");
                } else if ("tst1_Complex_hjo.TabularSimple[firstName].value".equals(indicatorName)) {
                    actualsIndicators.add(indicatorName);
                    Assert.assertEquals(value, "Helene", "Invalid 'tst1_Complex_hjo.TabularSimple[firstName].value' value !");
                } else {
                    Assert.fail("The '" + indicatorName + "' indicator shoud not be collected !");
                }
            }
        } finally {
            if (reader != null) {
                reader.close();
            }
        }
        Assert.assertFalse(emptyOutput, "There is no collects in the output " + fName);
        Assert.assertTrue(actualsIndicators.containsAll(expectedIndicators), "Some indicators are missing !");
    }

    /**
     * Check the collects corresponding to the ptst1_Complex_hjo_person probe.
     */
    @Test
    public void testComplexHjoPerson() throws Exception {
        logger.debug(">> testComplexHjoPerson");
        String fName = getTmpDirPath() + "tst1_Complex_hjo_person.csv";
        CSVReader reader = null;
        boolean emptyOutput = true;
        ArrayList<String> actualsIndicators = new ArrayList<String>();
        ArrayList<String> expectedIndicators = new ArrayList<String>();
        expectedIndicators.add("tst1_Complex_hjo_person.Person.firstName");
        expectedIndicators.add("tst1_Complex_hjo_person.Person.lastName");
        expectedIndicators.add("tst1_Complex_hjo_person.Person.sexe");
        expectedIndicators.add("tst1_Complex_hjo_person.Person.yearOfBirth");
        expectedIndicators.add("tst1_Complex_hjo_person.Person.address.addr");
        expectedIndicators.add("tst1_Complex_hjo_person.Person.address.city");
        expectedIndicators.add("tst1_Complex_hjo_person.Person.address.code");
        expectedIndicators.add("tst1_Complex_hjo_person.Person.children[0]");
        expectedIndicators.add("tst1_Complex_hjo_person.Person.children[1]");
        try {
            reader = new CSVReader(new FileReader(fName), ';');
            String[] nextLine;
            String indicatorName;
            String value;
            while ((nextLine = reader.readNext()) != null) {
                // nextLine[] is an array of values from the line
                indicatorName = Util.getNameOfFullName(nextLine[Util.CSV_INDEX_NAME]);
                value = nextLine[Util.CSV_INDEX_VALUE];
                emptyOutput = false;
                if ("tst1_Complex_hjo_person.Person.firstName".equals(indicatorName)) {
                    actualsIndicators.add("tst1_Complex_hjo_person.Person.firstName");
                    Assert.assertEquals(value, "Helene", "Invalid 'tst1_Complex_hjo_person.Person.firstName' value !");
                } else if ("tst1_Complex_hjo_person.Person.lastName".equals(indicatorName)) {
                    actualsIndicators.add("tst1_Complex_hjo_person.Person.lastName");
                    Assert.assertEquals(value, "des Bois", "Invalid 'tst1_Complex_hjo_person.Person.lastName' value !");
                } else if ("tst1_Complex_hjo_person.Person.sexe".equals(indicatorName)) {
                    actualsIndicators.add("tst1_Complex_hjo_person.Person.sexe");
                    Assert.assertEquals(value, "FEMALE", "Invalid 'tst1_Complex_hjo_person.Person.sexe' value !");
                } else if ("tst1_Complex_hjo_person.Person.yearOfBirth".equals(indicatorName)) {
                    actualsIndicators.add("tst1_Complex_hjo_person.Person.yearOfBirth");
                    Assert.assertEquals(value, "1959", "Invalid 'tst1_Complex_hjo_person.Person.yearOfBirth' value !");
                } else if ("tst1_Complex_hjo_person.Person.address.addr".equals(indicatorName)) {
                    actualsIndicators.add("tst1_Complex_hjo_person.Person.address.addr");
                    Assert.assertEquals(value, "rue Principale", "Invalid 'tst1_Complex_hjo_person.Person.address.addr' value !");
                } else if ("tst1_Complex_hjo_person.Person.address.city".equals(indicatorName)) {
                    actualsIndicators.add("tst1_Complex_hjo_person.Person.address.city");
                    Assert.assertEquals(value, "SMH", "Invalid 'tst1_Complex_hjo_person.Person.address.city' value !");
                } else if ("tst1_Complex_hjo_person.Person.address.code".equals(indicatorName)) {
                    actualsIndicators.add("tst1_Complex_hjo_person.Person.address.code");
                    Assert.assertEquals(value, "38400", "Invalid 'tst1_Complex_hjo_person.Person.address.code' value !");
                } else if ("tst1_Complex_hjo_person.Person.children[0]".equals(indicatorName)) {
                    actualsIndicators.add("tst1_Complex_hjo_person.Person.children[0]");
                    Assert.assertEquals(value, "1987", "Invalid 'tst1_Complex_hjo_person.Person.children[0]' value !");
                } else if ("tst1_Complex_hjo_person.Person.children[1]".equals(indicatorName)) {
                    actualsIndicators.add("tst1_Complex_hjo_person.Person.children[1]");
                    Assert.assertEquals(value, "1990", "Invalid 'tst1_Complex_hjo_person.Person.children[1]' value !");
                } else {
                    Assert.fail("The '" + indicatorName + "' indicator shoud not be collected !");
                }
            }
        } finally {
            if (reader != null) {
                reader.close();
            }
        }
        Assert.assertFalse(emptyOutput, "There is no collects in the output " + fName);
        Assert.assertTrue(actualsIndicators.containsAll(expectedIndicators), "Some indicators are missing !");
    }

    /**
     * Check the collects corresponding to the ptst1_Complex_hjo_person_first_name probe.
     */
    @Test
    public void testComplexHjoPersonFirstName() throws Exception {
        logger.debug(">> testComplexHjoPersonFirstName");
        String fName = getTmpDirPath() + "tst1_Complex_hjo_person_firstname.csv";
        CSVReader reader = null;
        boolean emptyOutput = true;
        try {
            reader = new CSVReader(new FileReader(fName), ';');
            String[] nextLine;
            String indicatorName;
            String value;
            while ((nextLine = reader.readNext()) != null) {
                // nextLine[] is an array of values from the line
                indicatorName = Util.getNameOfFullName(nextLine[Util.CSV_INDEX_NAME]);
                value = nextLine[Util.CSV_INDEX_VALUE];
                if ("tst1_Complex_hjo_person_firstname".equals(indicatorName)) {
                    emptyOutput = false;
                    Assert.assertEquals(value, "Helene", "Invalid 'tst1_Complex_hjo_person_firstname' value !");
                } else {
                    Assert.fail("The '" + indicatorName + "' indicator shoud not be collected !");
                }
            }
        } finally {
            if (reader != null) {
                reader.close();
            }
        }
        Assert.assertFalse(emptyOutput, "There is no collects in the output " + fName);
    }

    /**
     * Check the collects corresponding to the ptst1_Complex_hjo_person_first_name probe.
     */
    @Test
    public void testComplexHjoPersonAddressCity() throws Exception {
        logger.debug(">> testComplexHjoPersonAddressCity");
        String fName = getTmpDirPath() + "tst1_Complex_hjo_person_address_city.csv";
        CSVReader reader = null;
        boolean emptyOutput = true;
        try {
            reader = new CSVReader(new FileReader(fName), ';');
            String[] nextLine;
            String indicatorName;
            String value;
            while ((nextLine = reader.readNext()) != null) {
                // nextLine[] is an array of values from the line
                indicatorName = Util.getNameOfFullName(nextLine[Util.CSV_INDEX_NAME]);
                value = nextLine[Util.CSV_INDEX_VALUE];
                if ("tst1_Complex_hjo_person_address_city".equals(indicatorName)) {
                    emptyOutput = false;
                    Assert.assertEquals(value, "SMH", "Invalid 'tst1_Complex_hjo_person_address_city' value !");
                } else {
                    Assert.fail("The '" + indicatorName + "' indicator shoud not be collected !");
                }
            }
        } finally {
            if (reader != null) {
                reader.close();
            }
        }
        Assert.assertFalse(emptyOutput, "There is no collects in the output " + fName);
    }

    /**
     * Check the collects corresponding to the ptst1_Complex_hjo_person_children_0 probe.
     */
    @Test
    public void testComplexHjoPersonChildren0() throws Exception {
        logger.debug(">> testComplexHjoChildren0");
        String fName = getTmpDirPath() + "tst1_Complex_hjo_person_children_0.csv";
        CSVReader reader = null;
        boolean emptyOutput = true;
        try {
            reader = new CSVReader(new FileReader(fName), ';');
            String[] nextLine;
            String indicatorName;
            String value;
            while ((nextLine = reader.readNext()) != null) {
                // nextLine[] is an array of values from the line
                indicatorName = Util.getNameOfFullName(nextLine[Util.CSV_INDEX_NAME]);
                value = nextLine[Util.CSV_INDEX_VALUE];
                if ("tst1_Complex_hjo_person_children_0".equals(indicatorName)) {
                    emptyOutput = false;
                    Assert.assertEquals(value, "1987", "Invalid 'tst1_Complex_hjo_person_children_0' value !");
                } else {
                    Assert.fail("The '" + indicatorName + "' indicator shoud not be collected !");
                }
            }
        } finally {
            if (reader != null) {
                reader.close();
            }
        }
        Assert.assertFalse(emptyOutput, "There is no collects in the output " + fName);
    }

    /**
     * Check the collects corresponding to the ptst1_Complex_hjo_string_array probe.
     */
    @Test
    public void testComplexHjoStringArray() throws Exception {
        logger.debug(">> testComplexHjoStringArray");
        String fName = getTmpDirPath() + "tst1_Complex_hjo_string_array.csv";
        CSVReader reader = null;
        boolean emptyElt0 = true;
        boolean emptyElt1 = true;
        try {
            reader = new CSVReader(new FileReader(fName), ';');
            String[] nextLine;
            String indicatorName;
            String value;
            while ((nextLine = reader.readNext()) != null) {
                // nextLine[] is an array of values from the line
                indicatorName = Util.getNameOfFullName(nextLine[Util.CSV_INDEX_NAME]);
                value = nextLine[Util.CSV_INDEX_VALUE];
                if ("tst1_Complex_hjo_string_array.StringArray[0]".equals(indicatorName)) {
                    emptyElt0 = false;
                    Assert.assertEquals(value, "Helene", "Invalid 'tst1_Complex_hjo_string_array.StringArray[0]' value !");
                } else if ("tst1_Complex_hjo_string_array.StringArray[1]".equals(indicatorName)) {
                    emptyElt1 = false;
                    Assert.assertEquals(value, "des Bois", "Invalid 'tst1_Complex_hjo_string_array.StringArray[1]' value !");
                } else {
                    Assert.fail("The '" + indicatorName + "' indicator shoud not be collected !");
                }
            }
        } finally {
            if (reader != null) {
                reader.close();
            }
        }
        Assert.assertFalse(emptyElt0, "There is no collects for tst1_Complex_hjo_string_array.StringArray[0] in the output " + fName);
        Assert.assertFalse(emptyElt1, "There is no collects for tst1_Complex_hjo_string_array.StringArray[0] in the output " + fName);
    }

    /**
     * Check the collects corresponding to the ptst1_Complex_hjo_string_array_some probe.
     */
    @Test
    public void testComplexHjoStringArraySome() throws Exception {
        logger.debug(">> testComplexHjoStringArraySome");
        String fName = getTmpDirPath() + "tst1_Complex_hjo_string_array_some.csv";
        CSVReader reader = null;
        boolean emptyElt0 = true;
        boolean emptyElt1 = true;
        try {
            reader = new CSVReader(new FileReader(fName), ';');
            String[] nextLine;
            String indicatorName;
            String value;
            while ((nextLine = reader.readNext()) != null) {
                // nextLine[] is an array of values from the line
                indicatorName = Util.getNameOfFullName(nextLine[Util.CSV_INDEX_NAME]);
                value = nextLine[Util.CSV_INDEX_VALUE];
                if ("tst1_Complex_hjo_string_array_some.StringArray[0]".equals(indicatorName)) {
                    emptyElt0 = false;
                    Assert.assertEquals(value, "Helene", "Invalid 'tst1_Complex_hjo_string_array_some.StringArray[0]' value !");
                } else if ("tst1_Complex_hjo_string_array_some.StringArray[1]".equals(indicatorName)) {
                    emptyElt1 = false;
                    Assert.assertEquals(value, "des Bois", "Invalid 'tst1_Complex_hjo_string_array_some.StringArray[1]' value !");
                } else {
                    Assert.fail("The '" + indicatorName + "' indicator shoud not be collected !");
                }
            }
        } finally {
            if (reader != null) {
                reader.close();
            }
        }
        Assert.assertFalse(emptyElt0, "There is no collects for tst1_Complex_hjo_string_array_some.StringArray[0] in the output " + fName);
        Assert.assertFalse(emptyElt1, "There is no collects for tst1_Complex_hjo_string_array_some.StringArray[0] in the output " + fName);
    }

    /**
     * Check the collects corresponding to the ptst1_Complex_hjo_int_array probe.
     */
    @Test
    public void testComplexHjoIntArray() throws Exception {
        logger.debug(">> testComplexHjoIntArray");
        String fName = getTmpDirPath() + "tst1_Complex_hjo_int_array.csv";
        CSVReader reader = null;
        boolean emptyElt0 = true;
        boolean emptyElt1 = true;
        boolean emptyElt2 = true;
        try {
            reader = new CSVReader(new FileReader(fName), ';');
            String[] nextLine;
            String indicatorName;
            String value;
            while ((nextLine = reader.readNext()) != null) {
                // nextLine[] is an array of values from the line
                indicatorName = Util.getNameOfFullName(nextLine[Util.CSV_INDEX_NAME]);
                value = nextLine[Util.CSV_INDEX_VALUE];
                if ("tst1_Complex_hjo_int_array.IntArray[0]".equals(indicatorName)) {
                    emptyElt0 = false;
                    Assert.assertEquals(value, "1959", "Invalid 'tst1_Complex_hjo_int_array.IntArray[0]' value !");
                } else if ("tst1_Complex_hjo_int_array.IntArray[1]".equals(indicatorName)) {
                    emptyElt1 = false;
                    Assert.assertEquals(value, "2959", "Invalid 'tst1_Complex_hjo_int_array.IntArray[1]' value !");
                } else if ("tst1_Complex_hjo_int_array.IntArray[2]".equals(indicatorName)) {
                    emptyElt2 = false;
                    Assert.assertEquals(value, "3959", "Invalid 'tst1_Complex_hjo_int_array.IntArray[2]' value !");
                } else {
                    Assert.fail("The '" + indicatorName + "' indicator shoud not be collected !");
                }
            }
        } finally {
            if (reader != null) {
                reader.close();
            }
        }
        Assert.assertFalse(emptyElt0, "There is no collects for tst1_Complex_hjo_int_array.IntArray[0] in the output " + fName);
        Assert.assertFalse(emptyElt1, "There is no collects for tst1_Complex_hjo_int_array.IntArray[0] in the output " + fName);
        Assert.assertFalse(emptyElt2, "There is no collects for tst1_Complex_hjo_int_array.IntArray[0] in the output " + fName);
    }

    /**
     * Check the collects corresponding to the ptst1_Complex_hjo_int_array_some probe.
     */
    @Test
    public void testComplexHjoIntArraySome() throws Exception {
        logger.debug(">> testComplexHjoIntArraySome");
        String fName = getTmpDirPath() + "tst1_Complex_hjo_int_array_some.csv";
        CSVReader reader = null;
        boolean emptyOutput = true;
        try {
            reader = new CSVReader(new FileReader(fName), ';');
            String[] nextLine;
            String indicatorName;
            String value;
            while ((nextLine = reader.readNext()) != null) {
                // nextLine[] is an array of values from the line
                indicatorName = Util.getNameOfFullName(nextLine[Util.CSV_INDEX_NAME]);
                value = nextLine[Util.CSV_INDEX_VALUE];
                 if ("tst1_Complex_hjo_int_array_some".equals(indicatorName)) {
                    emptyOutput = false;
                    Assert.assertEquals(value, "1959", "Invalid 'tst1_Complex_hjo_int_array.IntArray[0]' value !");
                } else {
                    Assert.fail("The '" + indicatorName + "' indicator shoud not be collected !");
                }
            }
        } finally {
            if (reader != null) {
                reader.close();
            }
        }
        Assert.assertFalse(emptyOutput, "There is no collects in the output " + fName);
    }


    /**
     * Check the collects corresponding to the ptst1_Complex_hjo_tabular_simple probe.
     */
    @Test
    public void testComplexHjoTabularSimple() throws Exception {
        logger.debug(">> testComplexHjoTabularSimple");
        String fName = getTmpDirPath() + "tst1_Complex_hjo_tabular_simple.csv";
        CSVReader reader = null;
        boolean emptyKey0 = true;
        boolean emptyValue0 = true;
        boolean emptyKey1 = true;
        boolean emptyValue1 = true;
        try {
            reader = new CSVReader(new FileReader(fName), ';');
            String[] nextLine;
            String indicatorName;
            String value;
            while ((nextLine = reader.readNext()) != null) {
                // nextLine[] is an array of values from the line
                indicatorName = Util.getNameOfFullName(nextLine[Util.CSV_INDEX_NAME]);
                value = nextLine[Util.CSV_INDEX_VALUE];
                if ("tst1_Complex_hjo_tabular_simple.TabularSimple[firstName].key".equals(indicatorName)) {
                    emptyKey0 = false;
                    Assert.assertEquals(value, "firstName", "Invalid 'tst1_Complex_hjo_tabular_simple.TabularSimple[firstName].key' value !");
                } else if ("tst1_Complex_hjo_tabular_simple.TabularSimple[firstName].value".equals(indicatorName)) {
                    emptyValue0 = false;
                    Assert.assertEquals(value, "Helene", "Invalid 'tst1_Complex_hjo_tabular_simple.TabularSimple[firstName].value' value !");
                } else if ("tst1_Complex_hjo_tabular_simple.TabularSimple[lastName].key".equals(indicatorName)) {
                    emptyKey1 = false;
                    Assert.assertEquals(value, "lastName", "Invalid 'tst1_Complex_hjo_tabular_simple.TabularSimple[lastName].key' value !");
                } else if ("tst1_Complex_hjo_tabular_simple.TabularSimple[lastName].value".equals(indicatorName)) {
                    emptyValue1 = false;
                    Assert.assertEquals(value, "des Bois", "Invalid 'tst1_Complex_hjo_tabular_simple.TabularSimple[lastNameName].value' value !");
                } else {
                    Assert.fail("The '" + indicatorName + "' indicator shoud not be collected !");
                }
            }
        } finally {
            if (reader != null) {
                reader.close();
            }
        }
        Assert.assertFalse(emptyKey0, "There is no collects for tst1_Complex_hjo_tabular_simple.TabularSimple[firstName].key in the output " + fName);
        Assert.assertFalse(emptyValue0, "There is no collects for tst1_Complex_hjo_tabular_simple.TabularSimple[firstName].value in the output " + fName);
        Assert.assertFalse(emptyKey1, "There is no collects for tst1_Complex_hjo_tabular_simple.TabularSimple[lastName].key in the output " + fName);
        Assert.assertFalse(emptyValue1, "There is no collects for tst1_Complex_hjo_tabular_simple.TabularSimple[lastName].value in the output " + fName);
    }

    /**
     * Check the collects corresponding to the ptst1_Complex_hjo_tabular_simple_some probe.
     */
    @Test
    public void testComplexHjoTabularSimpleSome() throws Exception {
        logger.debug(">> testComplexHjoTabularSimpleSome");
        String fName = getTmpDirPath() + "tst1_Complex_hjo_tabular_simple_some.csv";
        CSVReader reader = null;
        boolean emptyOutput = true;
        try {
            reader = new CSVReader(new FileReader(fName), ';');
            String[] nextLine;
            String indicatorName;
            String value;
            while ((nextLine = reader.readNext()) != null) {
                // nextLine[] is an array of values from the line
                indicatorName = Util.getNameOfFullName(nextLine[Util.CSV_INDEX_NAME]);
                value = nextLine[Util.CSV_INDEX_VALUE];
                if ("tst1_Complex_hjo_tabular_simple_some".equals(indicatorName)) {
                    emptyOutput = false;
                    Assert.assertEquals(value, "des Bois", "Invalid 'tst1_Complex_hjo_tabular_simple_some' value !");
                } else {
                    Assert.fail("The '" + indicatorName + "' indicator shoud not be collected !");
                }
            }
        } finally {
            if (reader != null) {
                reader.close();
            }
        }
        Assert.assertFalse(emptyOutput, "There is no collects in the output " + fName);
    }

    /**
     * Check the collects corresponding to the ptst1_Complex_hjo_struct_one_field probe.
     */
    @Test
    public void testComplexHjoStructOneField() throws Exception {
        logger.debug(">> testComplexHjoStructOneField");
        String fName = getTmpDirPath() + "tst1_Complex_hjo_struct_one_field.csv";
        CSVReader reader = null;
        boolean emptyOutput = true;
        try {
            reader = new CSVReader(new FileReader(fName), ';');
            String[] nextLine;
            String indicatorName;
            String value;
            while ((nextLine = reader.readNext()) != null) {
                // nextLine[] is an array of values from the line
                indicatorName = Util.getNameOfFullName(nextLine[Util.CSV_INDEX_NAME]);
                value = nextLine[Util.CSV_INDEX_VALUE];
                if ("tst1_Complex_hjo_struct_one_field.StructOneField.field1".equals(indicatorName)) {
                    emptyOutput = false;
                    Assert.assertEquals(value, "Helene des Bois", "Invalid 'tst1_Complex_hjo_struct_one_field.StructOneField.field1' value !");
                } else {
                    Assert.fail("The '" + indicatorName + "' indicator shoud not be collected !");
                }
            }
        } finally {
            if (reader != null) {
                reader.close();
            }
        }
        Assert.assertFalse(emptyOutput, "There is no collects in the output " + fName);
    }
    
    /**
     * Check the collects corresponding to the ptst1_Complex_hjo_struct_one_field probe.
     */
    @Test
    public void testComplexHjoLongArrayOneElt() throws Exception {
        logger.debug(">> testComplexHjoLongArrayOneElt");
        String fName = getTmpDirPath() + "tst1_Complex_hjo_long_array_one_elt.csv";
        CSVReader reader = null;
        boolean emptyOutput = true;
        try {
            reader = new CSVReader(new FileReader(fName), ';');
            String[] nextLine;
            String indicatorName;
            String value;
            while ((nextLine = reader.readNext()) != null) {
                // nextLine[] is an array of values from the line
                indicatorName = Util.getNameOfFullName(nextLine[Util.CSV_INDEX_NAME]);
                value = nextLine[Util.CSV_INDEX_VALUE];
                if ("tst1_Complex_hjo_long_array_one_elt.LongArrayOneElt[0]".equals(indicatorName)) {
                    emptyOutput = false;
                    Assert.assertEquals(Integer.parseInt(value), 1001959, "Invalid 'tst1_Complex_hjo_long_array_one_elt.LongArrayOneElt[0]' value !");
                } else {
                    Assert.fail("The '" + indicatorName + "' indicator shoud not be collected !");
                }
            }
        } finally {
            if (reader != null) {
                reader.close();
            }
        }
        Assert.assertFalse(emptyOutput, "There is no collects in the output " + fName);
    }
}
