/**
 * JASMINe
 * Copyright (C) 2013 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 */

package org.ow2.jasmine.probe.shell;

import org.apache.felix.gogo.commands.Action;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.HandlerDeclaration;
import org.apache.felix.ipojo.annotations.Requires;
import org.apache.felix.service.command.CommandSession;
import org.ow2.jasmine.probe.JasmineProbeManager;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

import java.util.Iterator;
import java.util.Set;

/**
 * Shell command: output-types
 *
 * @author durieuxp
 */
@Component
@Command(name = "output-types",
        scope = "jasmine",
        description = "List all available output types")
@HandlerDeclaration("<sh:command xmlns:sh='org.ow2.shelbie'/>")
public class OutputTypes implements Action {

    @Requires
    JasmineProbeManager probeManager = null;

    protected static Log logger = LogFactory.getLog(Util.class);

    public Object execute(CommandSession commandSession) {

        logger.debug("");

        try {
            Set<String> types = probeManager.getOutputTypes();
            if (types.isEmpty()) {
                System.out.println("There are no available JasmineOutput types");
            } else {
                System.out.println("Available JasmineOutput types:");
                for (Iterator<String> itTypes = types.iterator(); itTypes.hasNext(); ) {
                    System.out.println(itTypes.next());
                }
            }
        } catch (Exception e) {
            logger.error("output-types failed", e);
        }
        return null;
    }


}