package org.ow2.jasmine.probe.rest.impl;

import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;

import org.ow2.jasmine.probe.JasmineProbeException;
import org.ow2.jasmine.probe.api.generated.ErrorType;

public class RestUtil {

    protected static Response errorResponse(JasmineProbeException e, Response.Status _status) {
        ErrorType err = new ErrorType();
        err.setMessage(e.getMessage());
        QName qname  = new QName("org.ow2.jasmine.probe:probe-config", "error");
        JAXBElement<ErrorType> errElem = new JAXBElement<ErrorType>(qname, ErrorType.class, err);
        return Response
            .status(_status)
            .entity(errElem)
            .type(MediaType.APPLICATION_XML)
            .build();
    }
}
