/**
 * JASMINe
 * Copyright (C) 2011 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id$
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.probe.util.internal;

public class FragmentName {


    // Naming policy
    public static String DOT = ".";
    public static String COMMA = ",";
    public static String brackleft = "[";
    public static String brackright= "]";

    /**
     * Generate the name of a ComositeData's item
     */
    public static String getCompName(String name, String key) {
        String compName = name + DOT + key;
        return compName;
    }

    /**
     *
     * @param name
     * @param indexes The value of the indexes of a row. At least one index is provided.
     * @return
     */
    public static String getRowName(String name, Object[] indexes) {
        String s_indexes = indexes[0].toString();
        if (indexes.length > 1) {
            for (int i = 1; i < indexes.length; i++) {
                s_indexes = s_indexes + COMMA + indexes[i];
            }
        }
        String rowName = name + brackleft + s_indexes + brackright;
        return rowName;
    }

    public static String getArrayElementName(String name, int index) {
        return name + brackleft + index + brackright;
    }

}
