#set( $symbol_pound = '#' )
#set( $symbol_dollar = '$' )
#set( $symbol_escape = '\' )
package ${package};

import org.apache.felix.ipojo.annotations.*;
import org.ow2.jasmine.probe.JasmineOutput;
import org.ow2.jasmine.probe.JasminePropertyInfo;
import org.ow2.jasmine.probe.outer.JasmineOuter;
import org.ow2.jasmine.probe.outer.JasmineOuterException;
import org.ow2.jasmine.probe.outers.JOuter;
import org.ow2.jasmine.probe.outers.JOuterService;

import java.util.ArrayList;

/**
 * Manages a list of JOuter objects (in fact TemplateOuter instances).
 * @author durieuxp
 */
@Component(name="TemplateOuterService")
@Provides
public class TemplateOuterService extends JOuterService {

    @ServiceProperty(name="output.type", value="${output-type}")
    private String outputType;

    @Validate
    public void start() {
        // init the list of properties
        properties = new ArrayList<JasminePropertyInfo>();
        //properties.add(new JasminePropertyInfo("path", "full pathname of the file", true));
    }

    @Invalidate
    public void stop() {
        // Mark as removed the outers corresponding to output.type
        removeOuters(null);
    }

    // --------------------------------------------------------------------------------
    //  JasmineOuterService implementation
    // --------------------------------------------------------------------------------

    /**
     * Create an Outer for this JasmineOutput
     * @param jasmineOutput
     * @return the Outer
     * @throws JasmineOuterException operation failed
     */
    public synchronized JasmineOuter getOuter(JasmineOutput jasmineOutput) throws JasmineOuterException {
        String name = jasmineOutput.getName();
        JOuter outer = outerList.get(name);
        if (outer == null) {
            outer = new TemplateOuter(jasmineOutput);
            outerList.put(name, outer);
            outer.start();
        }
        return outer;
    }

    public String getType() {
        return outputType;
    }
}
