/**
 * JASMINe
 * Copyright (C) 2011 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id$
 * --------------------------------------------------------------------------
 */

package org.ow2.jasmine.probe.itests;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;

import org.ow2.jasmine.probe.JasmineProbeException;

import org.testng.Assert;
import org.testng.annotations.Test;

public class BasicTest extends JOnASLauncher {

    /**
     * Test the 'agent0' target exists.
     * @throws Exception
     */
    @Test
    public void testTargetAgent0() throws Exception {
        logger.debug(">> testTargetAgent0");
        final String name = "agent0";
        try {
            getProxyMXBean().getTarget(name);
        } catch (JasmineProbeException e) {
            Assert.fail("The target '" + name + "' is not defined");
        }
    }

    /**
     * Test the 'stdio' output exists.
     * @throws Exception
     */
    @Test
    public void testOutputStdio() throws Exception {
        logger.debug(">> testOutputStdio");
        final String name = "stdio";
        try {
            getProxyMXBean().getOutput(name);
        } catch (JasmineProbeException e) {
            Assert.fail("The output '" + name + "' is not defined");
        }
    }

    /**
     * Test a not defined output doesn't exist.
     * @throws Exception
     */
    @Test
    public void testOutputUnknown() throws Exception {
        logger.debug(">> testOutputUnknown");
        final String name = "___unknown___";
        boolean ko = true;
        try {
            getProxyMXBean().getOutput(name);
        } catch (Exception e) {
            ko = false;
        }
        Assert.assertFalse(ko, "The output '" + name + "' should not exist");
    }

    /**
     * Test the validity of the possible output types ie "console", "file", "mule".
     * @throws Exception
     */
    @Test
    public void testOutputTypes() throws Exception {
        logger.debug(">> testOutputTypes");
        ArrayList <String> outputTypesExpected = new ArrayList<String>(Arrays.asList("console", "file", "mule"));
        Set <String> outputTypes = getProxyMXBean().getOutputTypes();
        Assert.assertTrue(outputTypes.containsAll(outputTypesExpected), "The output types list is not correct. (Actual = " + outputTypes.toString() + ", Expected = " + outputTypesExpected.toString() + ")");
        Assert.assertTrue(outputTypesExpected.containsAll(outputTypes), "The output types list is not correct. (Actual = " + outputTypes.toString() + ", Expected = " + outputTypesExpected.toString() + ")");
    }

    /**
     * Test the validity of the possible indicator types ie "aggregate", "constant", "correlate", "derived", "df", "jmx", "lewys", "merge", "slope".
     * @throws Exception
     */
    @Test
    public void testIndicatorTypes() throws Exception {
        logger.debug(">> testIndicatorTypes");
        ArrayList <String> indicatorTypesExpected = new ArrayList<String>(Arrays.asList("aggregate", "constant", "correlate", "derived", "df", "jmx", "lewys", "merge", "slope"));
        Set <String> indicatorTypes = getProxyMXBean().getIndicatorTypes();
        Assert.assertTrue(indicatorTypes.containsAll(indicatorTypesExpected), "The indicator types list is not correct. (Actual = " + indicatorTypes.toString() + ", Expected = " + indicatorTypesExpected.toString() + ")");
        Assert.assertTrue(indicatorTypesExpected.containsAll(indicatorTypes), "The indicator types list is not correct. (Actual = " + indicatorTypes.toString() + ", Expected = " + indicatorTypesExpected.toString() + ")");
    }

}
