/**
 * JASMINe
 * Copyright (C) 2011 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id$
 * --------------------------------------------------------------------------
 */

package org.ow2.jasmine.probe.itests;

import java.util.StringTokenizer;

import org.testng.Assert;

public class Util {

    /*
     * Index in the jasmine-probe output CSV file of the time
     */
    public static final int CSV_INDEX_TIME = 0;

    /*
     * Index in the jasmine-probe output CSV file of the full value name
     */
    public static final int CSV_INDEX_NAME = 5;

    /*
     * Index in the jasmine-probe output CSV file of the value
     */
    public static final int CSV_INDEX_VALUE = 6;

    /**
     * The syntax of the full value name is 'objectname:name' as examples
     * - jasmine_tests:type=Basic,category=ab,name=mb_ab_01:CInt1 or
     * - misc:type=correlate:tst_mb_ab_xx_add_VIncremented
     * @return return the name part of the full name
     */
    public static String getNameOfFullName(String fullName) {
        StringTokenizer st = new StringTokenizer(fullName, ":");
        Assert.assertTrue((st.countTokens() == 3), "Full value name malformed (" + fullName + ")");
        st.nextToken();
        st.nextToken();
        return(st.nextToken());
    }

}
