/**
 * JASMINe
 * Copyright (C) 2012 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id $
 * --------------------------------------------------------------------------
 */


package org.ow2.jasmine.probe.itests;

import java.util.ArrayList;

import org.ow2.jasmine.probe.JasmineProbeException;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;

public class CnfJmxStructuredAttrIndicatorTest extends AbsStructuredAttrIndicatorTest {

    @BeforeClass
    public void createProbesAndWait() throws InterruptedException, JasmineProbeException {

        try {
            
            String cmdBegin = "java -jar " + getJmxClientJarName() + " -port " + getPortNumber() + " -server " + getServerName() +" ";
            logger.info("Exec of: " + cmdBegin + "...");
            
            ArrayList<String> cmdList = new ArrayList<String>();
            
            cmdList.add("target-create tst_agent1 -u " + getJmxUrl());
            cmdList.add("output-create stdio1 -t console");
            cmdList.add("output-create tst1_Logging_SomeLoggerNames -t file path="+getTmpDirPath()+"tst1_Logging_SomeLoggerNames.csv");
            cmdList.add("output-create tst1_Threading_SomeThreadIds -t file path="+getTmpDirPath()+"tst1_Threading_SomeThreadIds.csv");
            cmdList.add("output-create tst1_Memory_XMemoryUsage_used -t file path="+getTmpDirPath()+"tst1_Memory_XMemoryUsage_used.csv");
            cmdList.add("output-create tst1_Runtime_SystemProperties_jonas_name_value -t file path="+getTmpDirPath()+"tst1_Runtime_SystemProperties_jonas_name_value.csv");
            cmdList.add("output-create tst1_Complex_hjo -t file path="+getTmpDirPath()+"tst1_Complex_hjo.csv");
            cmdList.add("output-create tst1_Complex_hjo_person -t file path="+getTmpDirPath()+"tst1_Complex_hjo_person.csv");
            cmdList.add("output-create tst1_Complex_hjo_person_firstname -t file path="+getTmpDirPath()+"tst1_Complex_hjo_person_firstname.csv");
            cmdList.add("output-create tst1_Complex_hjo_person_address_city -t file path="+getTmpDirPath()+"tst1_Complex_hjo_person_address_city.csv");
            cmdList.add("output-create tst1_Complex_hjo_person_children_0 -t file path="+getTmpDirPath()+"tst1_Complex_hjo_person_children_0.csv");
            cmdList.add("output-create tst1_Complex_hjo_string_array -t file path="+getTmpDirPath()+"tst1_Complex_hjo_string_array.csv");
            cmdList.add("output-create tst1_Complex_hjo_string_array_some -t file path="+getTmpDirPath()+"tst1_Complex_hjo_string_array_some.csv");
            cmdList.add("output-create tst1_Complex_hjo_int_array -t file path="+getTmpDirPath()+"tst1_Complex_hjo_int_array.csv");
            cmdList.add("output-create tst1_Complex_hjo_int_array_some -t file path="+getTmpDirPath()+"tst1_Complex_hjo_int_array_some.csv");
            cmdList.add("output-create tst1_Complex_hjo_tabular_simple -t file path="+getTmpDirPath()+"tst1_Complex_hjo_tabular_simple.csv");
            cmdList.add("output-create tst1_Complex_hjo_tabular_simple_some -t file path="+getTmpDirPath()+"tst1_Complex_hjo_tabular_simple_some.csv");
            cmdList.add("output-create tst1_Complex_hjo_struct_one_field -t file path="+getTmpDirPath()+"tst1_Complex_hjo_struct_one_field.csv");
            cmdList.add("output-create tst1_Complex_hjo_long_array_one_elt -t file path="+getTmpDirPath()+"tst1_Complex_hjo_long_array_one_elt.csv ");
            cmdList.add("indicator-create tst1_Logging_SomeLoggerNames -t jmx target=tst_agent1 mbean=java.util.logging:type=Logging attr=LoggerNames[0],LoggerNames[3]");
            cmdList.add("indicator-create tst1_Threading_SomeThreadIds -t jmx target=tst_agent1 mbean=java.lang:type=Threading attr=AllThreadIds[0],AllThreadIds[5]");
            cmdList.add("indicator-create tst1_Memory_XMemoryUsage_used -t jmx target=tst_agent1 mbean=java.lang:type=Memory attr=HeapMemoryUsage.used,NonHeapMemoryUsage.used");
            cmdList.add("indicator-create tst1_Runtime_SystemProperties_jonas_name_value -t jmx target=tst_agent1 mbean=java.lang:type=Runtime attr=SystemProperties[jonas.name].value");
            cmdList.add("indicator-create tst1_Complex_hjo -t jmx target=tst_agent1 mbean=*:type=Complex,name=hjo attr=all");
            cmdList.add("indicator-create tst1_Complex_hjo_person -t jmx target=tst_agent1 mbean=*:type=Complex,name=hjo attr=Person");
            cmdList.add("indicator-create tst1_Complex_hjo_person_firstname -t jmx target=tst_agent1 mbean=*:type=Complex,name=hjo attr=Person.firstName");
            cmdList.add("indicator-create tst1_Complex_hjo_person_address_city -t jmx target=tst_agent1 mbean=*:type=Complex,name=hjo attr=Person.address.city");
            cmdList.add("indicator-create tst1_Complex_hjo_person_children_0 -t jmx target=tst_agent1 mbean=*:type=Complex,name=hjo attr=Person.children[0]");
            cmdList.add("indicator-create tst1_Complex_hjo_string_array -t jmx target=tst_agent1 mbean=*:type=Complex,name=hjo attr=StringArray");
            cmdList.add("indicator-create tst1_Complex_hjo_string_array_some -t jmx target=tst_agent1 mbean=*:type=Complex,name=hjo attr=StringArray[0],StringArray[1]");
            cmdList.add("indicator-create tst1_Complex_hjo_int_array -t jmx target=tst_agent1 mbean=*:type=Complex,name=hjo attr=IntArray");
            cmdList.add("indicator-create tst1_Complex_hjo_int_array_some -t jmx target=tst_agent1 mbean=*:type=Complex,name=hjo attr=IntArray[0]");
            cmdList.add("indicator-create tst1_Complex_hjo_tabular_simple -t jmx target=tst_agent1 mbean=*:type=Complex,name=hjo attr=TabularSimple");
            cmdList.add("indicator-create tst1_Complex_hjo_tabular_simple_some -t jmx target=tst_agent1 mbean=*:type=Complex,name=hjo attr=TabularSimple[lastName].value");
            cmdList.add("indicator-create tst1_Complex_hjo_struct_one_field -t jmx target=tst_agent1 mbean=*:type=Complex,name=hjo attr=StructOneField");
            cmdList.add("indicator-create tst1_Complex_hjo_long_array_one_elt -t jmx target=tst_agent1 mbean=*:type=Complex,name=hjo attr=LongArrayOneElt ");
            cmdList.add("probe-create ptst1_Logging_SomeLoggerNames -start -p 3 -o tst1_Logging_SomeLoggerNames -i tst1_Logging_SomeLoggerNames");
            cmdList.add("probe-create ptst1_Threading_SomeThreadIds -start -p 3 -o tst1_Threading_SomeThreadIds -i tst1_Threading_SomeThreadIds");
            cmdList.add("probe-create ptst1_Memory_XMemoryUsage_used -start -p 3 -o tst1_Memory_XMemoryUsage_used -i tst1_Memory_XMemoryUsage_used");
            cmdList.add("probe-create ptst1_Runtime_SystemProperties_jonas_name_value -start -p 3 -o tst1_Runtime_SystemProperties_jonas_name_value -i tst1_Runtime_SystemProperties_jonas_name_value");
            cmdList.add("probe-create ptst1_Complex_hjo -start -p 3 -o tst1_Complex_hjo -i tst1_Complex_hjo");
            cmdList.add("probe-create ptst1_Complex_hjo_person -start -p 3 -o tst1_Complex_hjo_person -i tst1_Complex_hjo_person");
            cmdList.add("probe-create ptst1_Complex_hjo_person_firstname -start -p 3 -o tst1_Complex_hjo_person_firstname -i tst1_Complex_hjo_person_firstname");
            cmdList.add("probe-create ptst1_Complex_hjo_person_address_city -start -p 3 -o tst1_Complex_hjo_person_address_city -i tst1_Complex_hjo_person_address_city");
            cmdList.add("probe-create ptst1_Complex_hjo_person_children_0 -start -p 3 -o tst1_Complex_hjo_person_children_0 -i tst1_Complex_hjo_person_children_0");
            cmdList.add("probe-create ptst1_Complex_hjo_string_array -start -p 3 -o tst1_Complex_hjo_string_array -i tst1_Complex_hjo_string_array");
            cmdList.add("probe-create ptst1_Complex_hjo_string_array_some -start -p 3 -o tst1_Complex_hjo_string_array_some -i tst1_Complex_hjo_string_array_some");
            cmdList.add("probe-create ptst1_Complex_hjo_int_array -start -p 3 -o tst1_Complex_hjo_int_array -i tst1_Complex_hjo_int_array");
            cmdList.add("probe-create ptst1_Complex_hjo_int_array_some -start -p 3 -o tst1_Complex_hjo_int_array_some -i tst1_Complex_hjo_int_array_some");
            cmdList.add("probe-create ptst1_Complex_hjo_tabular_simple -start -p 3 -o tst1_Complex_hjo_tabular_simple -i tst1_Complex_hjo_tabular_simple");
            cmdList.add("probe-create ptst1_Complex_hjo_tabular_simple_some -start -p 3 -o tst1_Complex_hjo_tabular_simple_some -i tst1_Complex_hjo_tabular_simple_some");
            cmdList.add("probe-create ptst1_Complex_hjo_struct_one_field -start -p 3 -o tst1_Complex_hjo_struct_one_field -i tst1_Complex_hjo_struct_one_field");
            cmdList.add("probe-create ptst1_Complex_hjo_long_array_one_elt -start -p 3 -o tst1_Complex_hjo_long_array_one_elt -i tst1_Complex_hjo_long_array_one_elt ");
            
            Runtime rt = Runtime.getRuntime();
            Process process;
            int pexit;

            for(String cmd: cmdList) {
                logger.info("-> " + cmd);
                process = rt.exec(cmdBegin + cmd);
                pexit = process.waitFor();
                if (pexit != 0) {
                    logger.info("      command execution ERROR");
                    // Assert.fail() not necessary because some tests will fail
                }
            }

        } catch (Exception e) {
            e.printStackTrace();
            Assert.fail("Error when creating indicators/probes", e);
        }
        logger.info("The indicators/probes have been successfully created via the JMX JProbe client");

        // Wait few mn to get the time to do some collects ....and than stop all the probes
        logger.info("Wait " + WAIT_COLLECTS_IN_SEC + " sec to get time to do some collects ...");
        Thread.sleep(WAIT_COLLECTS_IN_SEC*1000);
        getProxyMXBean().stopAllProbes();
    }

}
