/**
 * JASMINe
 * Copyright (C) 2011 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id$
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.probe.itests.dummymbeanservice;

import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;


/**
 * @author joaninh
 * 
 */

public class Basic implements BasicMBean {
    

    /**
     * Logger.
     */
    protected static Log logger = LogFactory.getLog(Basic.class);

    static public final int DEFAULT_INCREMENT = 1;
    static public final int DEFAULT_AMPLITUDE = 100;
    static public final int DEFAULT_STEP = 5;
    static public final int DEFAULT_INT_1 = 2000;
    static public final int DEFAULT_INT_2 = 50;
    static public final float DEFAULT_FLOAT_1 = DEFAULT_INT_1;
    static public final float DEFAULT_FLOAT_2 = DEFAULT_INT_2;
    
    private String name;

    private int cIncrement = DEFAULT_INCREMENT;
    private int cAmplitude = DEFAULT_AMPLITUDE;
    private int cStep = DEFAULT_STEP;
    private int vStep = DEFAULT_STEP;

    private int vIncremented = -DEFAULT_INCREMENT;
    private int vSinusoidal = -DEFAULT_STEP;
    private long vTimestamp;

    private int cInt1 = DEFAULT_INT_1;
    private int cInt2 = DEFAULT_INT_2;
    private float cFloat1 = DEFAULT_FLOAT_1;
    private float cFloat2 = DEFAULT_FLOAT_2;
    
    public Basic(final String name, final int increment, final int amplitude, final int step, final int i1, final int i2, final float f1, final float f2 ) {
        
        this.name = name;
        
        this.cIncrement = increment;
        this.cAmplitude = amplitude;
        this.cStep = step;
        this.vStep = step;

        this.vIncremented = -cIncrement;
        this.vSinusoidal = -cStep;
        this.vTimestamp = System.currentTimeMillis();
        
        this.cInt1 = i1;
        this.cInt2 = i2;
        this.cFloat1 = f1;
        this.cFloat2 = f2;
    }

    /* 
     */
    public String getName() {
        return name;
    }

    /* 
     */
    public int getCIncrement() {
        return cIncrement;
    }

    /* 
     */
    synchronized public void setCIncrement(int increment) {
        cIncrement = increment;
    }

    /* 
     */
    public int getCAmplitude() {
        return cAmplitude;
    }

    /* 
     */
    synchronized public void setCAmplitude(int amplitude) {
        cAmplitude = amplitude;
    }

    /* 
     */
    public int getCStep() {
        return cStep;
    }

    /*
     */
    synchronized public void setCStep(int step) {
        cStep = step;
    }

    /*
     */
    public String getVDescription() {
        return ("Basic: " + "incr=" + cIncrement + ", ampl=" + cAmplitude + ", step=" + cStep);
    }

    /**
     * Return the elapsed time since the previous getPeriod() call (time in second).
     * (Note that for the first call, this is the elapsed time since the MBean creation).
     */
    synchronized public int getVPeriod() {
        long ts = System.currentTimeMillis();
        // Do Math.round() to get the closest int value
        int period = Math.round((new Long(ts - vTimestamp)).floatValue() / 1000);
        vTimestamp = ts;
        return period;
    }

    /* 
     */
    synchronized public int getVIncremented() {
        vIncremented += cIncrement;
        //logger.info(name + ": VIncremented = " + vIncremented);
        return vIncremented;
    }

    /* 
     */
    synchronized public int getVSinusoidal() {
        vSinusoidal += vStep;
        if (StrictMath.abs(vSinusoidal) >= cAmplitude) {
            vStep = vStep * (-1);
        }
        return vSinusoidal;
    }

    /* 
     */
    public int getCInt1() {
        return cInt1;
    }

    /* 
     */
    public int getCInt2() {
        return cInt2;
    }

    /* 
     */
    public float getCFloat1() {
        return cFloat1;
    }

    /* 
     */
    public float getCFloat2() {
        return cFloat2;
    }

    /*
     */
    synchronized public void reset() {
        vIncremented = -cIncrement;
        vSinusoidal = -cStep;
        vTimestamp = System.currentTimeMillis();
    }

    /*
     */
    public String toString() {
        return ("Basic(" + "name = " + name + ", increment = " + cIncrement + ", amplitude = " + cAmplitude + ", step = " + cStep
                + ", int1 = " + cInt1 + ", int2 = " + cInt2 + ", float1 = " + cFloat1 + ", float2 = " + cFloat2 + ")");
    }

}
