<?xml version="1.0" encoding="UTF-8"?>
<!--
 - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 - JASMINe
 - Copyright (C) 2012 Bull S.A.S.
 - Contact: jasmine@ow2.org
 -
 - This library is free software; you can redistribute it and/or
 - modify it under the terms of the GNU Lesser General Public
 - License as published by the Free Software Foundation; either
 - version 2.1 of the License, or any later version.
 -
 - This library is distributed in the hope that it will be useful,
 - but WITHOUT ANY WARRANTY; without even the implied warranty of
 - MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 - Lesser General Public License for more details.
 -
 - You should have received a copy of the GNU Lesser General Public
 - License along with this library; if not, write to the Free Software
 - Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 - USA
 -
 - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 - $Id$
 - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
-->
<!--
  - XSLT transformation which allows to convert a probe-config.xml file to a list of JProbe JMX client command list,
  - ie target-create, output-create, indicator-create and probe-create.
  -
  - Just call as the following :
  -   $ xsltproc probeconfig2clientcmd.xslt <probe-config-xml-file-name> > res
  -   $ cat res | sed -s 's|^  |           cmdList.add("|' | sed -s 's|$|");|' | sed -s 's|@TMP_DIR@/|"+getTmpDirPath()+"|' > resFinal
  -
  -->

<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:pcfg="org.ow2.jasmine.probe:probe-config">

    <xsl:template match="/">

        <xsl:for-each select="pcfg:probe-config/pcfg:target">
  target-create <xsl:value-of select="@name" />
            <xsl:for-each select="pcfg:property">
                <xsl:text> </xsl:text>-u<xsl:text> </xsl:text><xsl:value-of select="@value" />
            </xsl:for-each>
        </xsl:for-each>

        <xsl:text> </xsl:text>

        <xsl:for-each select="pcfg:probe-config/pcfg:output">
  output-create <xsl:value-of select="@name" /><xsl:text> </xsl:text>-t<xsl:text> </xsl:text><xsl:value-of select="@type" />
            <xsl:for-each select="pcfg:property">
                <xsl:text> </xsl:text><xsl:value-of select="@key" />=<xsl:value-of select="@value" />
            </xsl:for-each>
        </xsl:for-each>

        <xsl:text> </xsl:text>

        <xsl:for-each select="pcfg:probe-config/pcfg:indicator">
  indicator-create <xsl:value-of select="@name" /> -t <xsl:value-of select="@type" />
            <xsl:for-each select="pcfg:property">
                <xsl:text> </xsl:text><xsl:value-of select="@key" />=<xsl:value-of select="@value" />
            </xsl:for-each>
            <xsl:for-each select="pcfg:source">
                <xsl:text> </xsl:text>-i<xsl:text> </xsl:text><xsl:apply-templates />
            </xsl:for-each>
        </xsl:for-each>

        <xsl:text> </xsl:text>

        <xsl:for-each select="pcfg:probe-config/pcfg:probe">
  probe-create <xsl:value-of select="@id" /> -start -p <xsl:value-of select="@period" />
            <xsl:for-each select="pcfg:output">
                <xsl:text> </xsl:text>-o<xsl:text> </xsl:text><xsl:apply-templates />
            </xsl:for-each>
            <xsl:for-each select="pcfg:target">
                <xsl:text> </xsl:text>-target<xsl:text> </xsl:text><xsl:apply-templates />
            </xsl:for-each>
            <xsl:for-each select="pcfg:indicator">
                <xsl:text> </xsl:text>-i<xsl:text> </xsl:text><xsl:apply-templates />
            </xsl:for-each>
        </xsl:for-each>

        <xsl:text> </xsl:text>

    </xsl:template>

</xsl:stylesheet>
