/**
 * JASMINe
 * Copyright (C) 2013 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 */

package org.ow2.jasmine.probe;

import java.util.HashMap;
import java.util.Map;

/**
 * Abstract class derived by all Jasmine objects:
 * indicators, outputs, targets.
 * @author durieuxp
 */
public abstract class JasmineObject {
    
    /**
     * identifier       
     * can be provided by the user or generated.
     */
    protected String name = null;
                                
    /**
     * type of Object: should identify the Service to be used.
     */
    protected String type = null;
                  
    /**
     * Type specific parameters
     */
    protected Map<String, String> properties = new HashMap<String, String>();

    protected JasmineObject() {
    }     
     
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }
          
    public Map<String, String> getProperties() {
        return properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public abstract String toLine();
}
