/**
 * JASMINe
 * Copyright (C) 2011 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id$
 * --------------------------------------------------------------------------
 */

package org.ow2.jasmine.probe.collectors.jmx;

import java.util.HashMap;
import java.util.Map;

import javax.management.AttributeList;
import javax.management.ObjectName;

/**
 * This Value Object holds the result of a collected data (attribute values) for a given mbean
 * on a given target.
 * @author durieuxp
 */
public class Metric {

    /**
     * Metric timestamp in millis
     */
    private long timestamp = 0;

    /**
     * ObjectName of the MBean
     */
    private ObjectName mbean = null;

    /**
     * Attribute list. Each element in the list may be:
     * - one the the MBean's Attribute, or
     * - a fragment of one the the MBean's Attribute.
     */
    private AttributeList attributes = null;

    /**
     * target name
     */
    private String target;

    /**
     * Other metadata in addition to target name and mbean.
     */
    private Map<String, String> properties = new HashMap<String, String>();

    /**
     * Set to false if only one simple value can be obtained by
     * polling this MBean. This means that only one attribute (or attribute fragment) is read
     * and that its value has a simple type.
     */
    private boolean multiValue = true;

    public boolean isMultiValue() {
        return multiValue;
    }

    public void setMultiValue(boolean multiValue) {
        this.multiValue = multiValue;
    }

    /**
     * Empty constructor.
     */
    public Metric() {
    }

    public long getTimestamp() {
        return timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public ObjectName getMBean() {
        return mbean;
    }

    public void setMBean(ObjectName mbean) {
        this.mbean = mbean;
    }

    public AttributeList getAttributeList() {
        return attributes;
    }

    public void setAttributeList(AttributeList attributes) {
        this.attributes = attributes;
    }

    public String getTarget() {
        return target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public String toString() {
        return target + ":" + mbean + ":" + attributes.toString();
    }


    public Map<String, String> getProperties() {
        return properties;
    }

    public void setProperty(String key, String value) {
        properties.put(key, value);
    }


}
