package org.ow2.jasmine.probe.jmxconnection.test;

import java.io.IOException;
import java.util.Map;

import javax.management.MBeanServerConnection;

import org.ow2.jasmine.probe.jmxconnection.JmxConnectionFactory;
import org.ow2.jasmine.probe.jmxconnection.JmxConnectionService;
import org.ow2.jasmine.probe.jmxconnection.JmxConnectionException;
import org.ow2.jasmine.probe.jmxconnection.simple.JmxConnectionServiceImpl;
import org.testng.annotations.Test;

import static org.testng.Assert.assertNotNull;
import static org.testng.Assert.assertFalse;
import static org.testng.Assert.assertTrue;


public class JmxConnectionTest {

    private static final String BAD_URL = "service:jmx:rmi";
    private static final String JONAS_URL = "service:jmx:rmi://localhost/jndi/rmi://localhost:1099/jrmpconnector_jonas";
    private static final String JONAS_BAD_URL = "service:jmx:rmi://localhost/jndi/rmi://localhost:109/jrmpconnector_jonas";
    private static final Map<String, String> ENV = null;
    private JmxConnectionServiceImpl jmxConn;
    private JmxConnectionFactory fact = null;

    @Test
    public JmxConnectionTest() throws Exception {
        jmxConn = new JmxConnectionServiceImpl();
        String name = "test";
        assertNotNull(name);
    }

    @Test
    public void testJmxConnectionBadUrl() throws Exception {
        boolean connectionOK;
        try {
            fact = jmxConn.getJmxConnectionFactory(BAD_URL, ENV);
            connectionOK = true;
        } catch (JmxConnectionException e) {
            System.out.println("Test BadUrl");
            System.out.println("Message: " + e.getMessage());
            connectionOK = false;
        }
        assertFalse(connectionOK);
    }


    @Test
    public void testJmxConnectionJonasBadUrl() throws Exception {
        boolean connectionOK;
        try {
            fact = jmxConn.getJmxConnectionFactory(JONAS_BAD_URL, ENV);
            System.out.println("JonasBadUrl connected");
            connectionOK = true;
        } catch (JmxConnectionException e) {
            System.out.println("Test JonasBadUrl");
            System.out.println("Message: " + e.getMessage());
            connectionOK = false;
        }
        assertFalse(connectionOK);
    }

    /**
     * This test may fail if the jonas server has a secured jmx connection.
     * In this case, the following message is printed out:
     * Message: java.lang.SecurityException: Authentication failed! Credentials required
     */
    @Test
    public void testJmxConnectionJonas() throws Exception {
        boolean connectionOK;
        MBeanServerConnection mbsc = null;
        try {
            fact = jmxConn.getJmxConnectionFactory(JONAS_URL, ENV);
            MBeanServerConnection conn = fact.getMBeanServerConnection();
            connectionOK = true;
        } catch (JmxConnectionException e) {
            System.out.println("Test JonasUrl");
            System.out.println("Message: " + e.getMessage());
            connectionOK = false;
        }
        assertTrue(connectionOK);
    }

    /**
     * This test may fail if the jonas server has a secured jmx connection.
     * In this case, the following message is printed out:
     * Message: java.lang.SecurityException: Authentication failed! Credentials required
     */
    @Test
    public void testJmxCloseConnectionJonas() throws Exception {
        boolean connectionOK;
        try {
            fact.close();
            MBeanServerConnection conn = fact.getMBeanServerConnection();
            connectionOK = true;
        } catch (JmxConnectionException e) {
            System.out.println("Test CloseJonasUrl");
            System.out.println("Message: " + e.getMessage());
            connectionOK = false;
        }
        assertTrue(connectionOK);
    }

    /**
     * This test may fail if the jonas server has a secured jmx connection.
     * In this case, the following message is printed out:
     * Message: java.lang.SecurityException: Authentication failed! Credentials required
     */
    @Test
    public void testJmxCloseConnectionJonasBis() throws Exception {
        boolean connectionOK;
        try {
            fact.close();
            MBeanServerConnection conn = fact.getMBeanServerConnection();
            connectionOK = true;
        } catch (JmxConnectionException e) {
            System.out.println("Test CloseJonasUrl");
            System.out.println("Message: " + e.getMessage());
            connectionOK = false;
        }
        assertTrue(connectionOK);
    }
}
