/**
 * JASMINe
 * Copyright (C) 2011 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id$
 * --------------------------------------------------------------------------
 */

package org.ow2.jasmine.probe.outers;

import org.ow2.jasmine.probe.JasmineOutput;
import org.ow2.jasmine.probe.JasminePropertyInfo;
import org.ow2.jasmine.probe.outer.JasmineOuter;
import org.ow2.jasmine.probe.outer.JasmineOuterException;
import org.ow2.jasmine.probe.outer.JasmineOuterService;
import org.ow2.jonas.jmx.JmxService;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

/**
 * Base class for all OuterServices
 * @author durieuxp
 */
public abstract class JOuterService implements JasmineOuterService {

    /**
     * Logger.
     */
    protected Log logger = LogFactory.getLog(JOuter.class);

    /**
     * List of Outer
     */
    protected Map<String, JOuter> outerList = new HashMap<String, JOuter>();

    protected List<JasminePropertyInfo> properties;

    protected JmxService jmxService = null;

    // ---------------------------------------------------------------------
    //  JasmineOuterService implementation
    // ---------------------------------------------------------------------

    public JmxService getJmxService() {
        return jmxService;
    }

    public void setJmxService(JmxService jmxService) {
        this.jmxService = jmxService;
    }

    // register MBean for an outer
    protected void registerJOuterMBean(JOuter outer) throws JasmineOuterException {
        if (jmxService != null) {
            JOuterMBean mbean = (JOuterMBean) outer;
            ObjectName on = null;
            try {
                on = new ObjectName("jasmine:type=jpouter,name=" + outer.output.getName());
            } catch (MalformedObjectNameException e) {
                throw new JasmineOuterException(e.toString());
            } catch (NullPointerException e) {
                throw new JasmineOuterException(e.toString());
            }
            jmxService.registerMBean(mbean, on);
        } else {
            throw new JasmineOuterException("JMX service not available for registering JOuter MBean");
        }
    }

    // unregister MBean for an outer
    protected void unregisterJOuterMBean(ObjectName on) {
        if (jmxService != null) {
            jmxService.unregisterMBean(on);
        }
    }

    /**
     * Create an Outer for this JasmineOutput
     * @param jasmineOutput
     * @return the Outer
     * @throws JasmineOuterException operation failed
     */
    public abstract JasmineOuter getOuter(JasmineOutput jasmineOutput) throws JasmineOuterException;

    /**
     * Remove Outers attached to this Output.
     * Called usually when the output has changed or is removed.
     * @param name  Output name
     */
    public synchronized void removeOuters(String name) {
        logger.debug(name);
        List<String> toremove = new ArrayList<String>();
        for (String key : outerList.keySet()) {
            JOuter outer = outerList.get(key);
            if (name == null || outer.getOutput().getName().equals(name)) {
                toremove.add(key);
            }
        }
        for (String rem : toremove) {
            outerList.get(rem).remove();
            outerList.remove(rem);
        }
    }

    /**
     * Retrieve the description of all specific properties hidden in JasmineOutput
     * Return a List of all properties with their description
     * @return  a List of property descriptions
     */
    public List<JasminePropertyInfo> getPropertiesInfo() {
        return properties;
    }

    public abstract String getType();
}
