/**
 * JASMINe
 * Copyright (C) 2012 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id$
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.probe.rest;

import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

import org.ow2.jasmine.probe.api.generated.OutputBaseType;

/**
 * Root resource class for outputs management.
 * Contains methods to treat HTTP requests on "output" resources.
 * @author danesa
 *
 */
@Path("/output")
public interface Outputs {

    public final String RESOURCE_NAME = "output";

    /**
     * Process HTTP GET requests.
     * Possible URIs are:
     *  /output that corresponds to 'output-list' command
     * or
     * /output?type={typeName} that corresponds to 'output-list -t typeName' command
     * or
     * /output?verbose="true" that corresponds to 'output-list -v' command
     * @return response containing the existent outputs
     */
    @GET
    @Produces(MediaType.APPLICATION_XML)
    Response getOutputs(@QueryParam("type") String type
            , @DefaultValue("false") @QueryParam("verbose") boolean verbose
            , @Context UriInfo ui);


    /**
     * Process HTTP GET requests having /output/{name} URI
     * Correspond to output-list -n name
     * @param name output name
     * @param type
     * @return response
     */
    @GET
    @Path("/{name}")
    @Produces(MediaType.APPLICATION_XML)
    Response getOutput(@PathParam("name") String name, @Context UriInfo ui);

    /**
     * Process HTTP POST requests having /output URI and new output definition in its body.
     * Corresponds to output-create command
     * @param outputDef new output's definition
     * @return response with state OK or BAD_REQUEST if create failed
     */
    @POST
    @Consumes(MediaType.APPLICATION_XML)
    @Produces(MediaType.APPLICATION_XML)
    Response createOutput(OutputBaseType outputDef);

    /**
     * Process HTTP PUT requests having /output/{name} URI and updated output definition in its body.
     * Corresponds to output-change -name command.
     *
     * @param outputDef updated output definition
     * @return response with state OK or NOT_FOUND or BAD_REQUEST if change failed
     */
    @PUT
    @Path("/{name}")
    @Consumes(MediaType.APPLICATION_XML)
    @Produces(MediaType.APPLICATION_XML)
    Response changeOutput(OutputBaseType outputDef, @PathParam("name") String name);

    /**
     * Process HTTP DELETE requests having /output/{name} URI
     * Corresponds to output-remove name
     * @param name the name of the output to remove
     * @return response with state OK or NOT_FOUND
     */
    @DELETE
    @Path("/{name}")
    @Produces(MediaType.APPLICATION_XML)
    Response deleteOutput(@PathParam("name") String name);
}
