/**
 * JASMINe
 * Copyright (C) 2012 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id$
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.probe.rest;

import org.ow2.jasmine.probe.JasmineProbeResult;

/**
 * Task objects are used to keep data collected by probes (JasmineProbeResult)
 * and transform this data into XML format.
 * Data is set by dedicated "rest" typed outputs.
 *
 * @author danesa
 */
public interface Task {

    /**
     * @return the task id
     */
    public String getTaskId();

    /**
     * Used by a 'rest' output to set data collected by a probe.
     * @param result the probe's result obtained at the last iteration.
     */
    public void setLastResult(JasmineProbeResult result);

}
