/**
 * JASMINe
 * Copyright (C) 2012 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id$
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.probe.rest.impl;

import java.net.URI;
import java.util.List;
import java.util.ArrayList;

import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;

import org.ow2.jasmine.probe.JasmineProbeException;
import org.ow2.jasmine.probe.api.generated.JsrType;
import org.ow2.jasmine.probe.rest.Tasks;
import org.ow2.jasmine.probe.rest.TasksManager;

import org.ow2.jasmine.probe.api.generated.TaskType;

public class JTasks implements Tasks {

    private TasksManager taskManager = null;

    public JTasks(TasksManager taskManager) {
        this.taskManager = taskManager;
    }

    @Override
    /**
     * @param id the task id
     * @return the data contained in a task
     */
    public Response getData(String id) {
        JTask task = (JTask) taskManager.getTask(id);
        if (task != null) {
            List<JAXBElement<JsrType>> elementsList = task.getLastResult();
            if (elementsList == null) {
                String mess = "Unavailable data for " + id;
                return RestUtil.errorResponse(new JasmineProbeException(mess), Response.Status.NOT_FOUND);
            }
            return Response
                            .status(Response.Status.OK)
                            .entity(new GenericEntity<List<JAXBElement<JsrType>>>(elementsList) {})
                            .type(MediaType.APPLICATION_XML_TYPE)
                            .build();
        } else {
            String mess = "Unknown task " + id;
            return RestUtil.errorResponse(new JasmineProbeException(mess), Response.Status.NOT_FOUND);
        }
    }

    @Override
    public Response getTasks(UriInfo ui) {

        List<JAXBElement<TaskType>> elementsList = new ArrayList<JAXBElement<TaskType>>();

        for (String taskId : taskManager.getTasks()) {
            TaskType taskElement = new TaskType();
            taskElement.setId(taskId);
            URI taskUri = ui.getAbsolutePathBuilder().path(taskId).build();
            taskElement.setHref(taskUri.toString());

            QName name  = new QName("org.ow2.jasmine.probe:probe-config", "task");
            JAXBElement<TaskType> xmlElement =  new JAXBElement<TaskType>(name, TaskType.class, taskElement);
            elementsList.add(xmlElement);
        }

        return Response
            .status(Response.Status.OK)
            .entity(new GenericEntity<List<JAXBElement<TaskType>>>(elementsList) {})
            .type(MediaType.APPLICATION_XML_TYPE)
            .build();
    }

}
