/**
 * JASMINe
 * Copyright (C) 2011 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id$
 * --------------------------------------------------------------------------
 */

package org.ow2.jasmine.probe.probescheduler.internal;

import org.ow2.jasmine.probe.probescheduler.SchedulerService;
import org.ow2.jasmine.probe.probescheduler.TaskReference;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class TaskReferenceImpl implements TaskReference {

    private Log logger = LogFactory.getLog(SchedulerService.class);

    private Runnable listener = null;
    private long remaining;     // millisec
    private long startvalue;    // millisec
    private long createtime;
    private boolean permanent = false;
    private boolean stopped = false;

    public TaskReferenceImpl(Runnable l, long timeout, boolean p) {
          listener = l;
          remaining = timeout;
          startvalue = timeout;
          createtime = System.currentTimeMillis();
          permanent = p;
    }


    /**
     * Restart timer to its initial value
     */
    public long restart() {
        logger.debug("");
        stopped = false;
        // remaining should be < 0 here.
        createtime = System.currentTimeMillis() + remaining;
        remaining += startvalue;
        return remaining;
    }

    /**
     * Process the Timer
     */
    public void process() {
        if (listener != null) {
            logger.debug("remaining = "+remaining);
            listener.run();
        }
    }

    /**
     * Update timer every second. Used by clock.
     * - this must be called with the timerList monitor.
     */
    public long update() {
        remaining = startvalue + createtime - System.currentTimeMillis();
        return remaining;
    }

    /**
     * Is this timer valid ?
     */
    public boolean valid() {
        return (listener != null);
    }

    /**
     * Is this timer permanent ?
     */
    public boolean ispermanent() {
        return permanent;
    }

    /**
     * Is this timer stopped ?
     */
    public boolean isStopped() {
        return stopped;
    }

    // -------------------------------------------------------------------------------------
    // Taskreference implementation
    // -------------------------------------------------------------------------------------

    /**
     * Cancels all non-running (and optionally interrupt currently-running) executions
     * of this task and returns immediately.
     * @param interrupt true if the currently running executions of this task must be immediately interrupted.
     */
    public void cancel(boolean interrupt) {
        logger.debug("");
        remaining = 100;
        listener = null;
        permanent = false;
        stopped = false;
    }

    /**
     * Change the timetout value
     * @param timeout  value in millisec.
     */
    public void changeTimeout(long timeout) {
        startvalue = timeout;
    }
}
