/**
 * JASMINe
 * Copyright (C) 2013 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 */

package org.ow2.jasmine.probe.shell;

import org.apache.felix.gogo.commands.Action;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.HandlerDeclaration;
import org.apache.felix.ipojo.annotations.Requires;
import org.apache.felix.service.command.CommandSession;
import org.ow2.jasmine.probe.JasmineProbeManager;
import org.ow2.jasmine.probe.JasminePropertyInfo;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

import java.util.List;

/**
 * Shell command: output-properties
 *
 * @author durieuxp
 */
@Component
@Command(name = "output-properties",
        scope = "jasmine",
        description = "List properties for the given output type. Mandatory properties are flagged by an *")
@HandlerDeclaration("<sh:command xmlns:sh='org.ow2.shelbie'/>")
public class OutputProperties implements Action {

    @Requires
    JasmineProbeManager probeManager = null;

    @Option(name = "-t", aliases = "--type", description = "Output Type", required = true, multiValued = false)
    private String type = null;

    protected static Log logger = LogFactory.getLog(Util.class);

    public Object execute(CommandSession commandSession) {

        logger.debug("");

        try {
            List<JasminePropertyInfo> properties = probeManager.getOutputPropertyInfos(type);
            if (properties == null) {
                logger.error("Invalid type " + type);
                return null;
            }
            if (!properties.isEmpty()) {
                System.out.println("The properties flagged with * are mandatory:");
                for (JasminePropertyInfo prop : properties) {
                    System.out.println(prop.toString());
                }
            }
        } catch (Exception e) {
            logger.error("output-properties failed", e);
        }
        return null;
    }


}