/**
 * JASMINe
 * Copyright (C) 2013 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 */

package org.ow2.jasmine.probe.shell;

import org.apache.felix.gogo.commands.Action;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.HandlerDeclaration;
import org.apache.felix.ipojo.annotations.Requires;
import org.apache.felix.service.command.CommandSession;
import org.ow2.jasmine.probe.JasmineProbe;
import org.ow2.jasmine.probe.JasmineProbeManager;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

import java.util.List;

/**
 * Shell command: probe-create
 *
 * @author durieuxp
 */
@Component
@Command(name = "probe-create",
        scope = "jasmine",
        description = "Create a JASMINe probe")
@HandlerDeclaration("<sh:command xmlns:sh='org.ow2.shelbie'/>")
public class ProbeCreate implements Action {

    @Requires
    JasmineProbeManager probeManager = null;

    @Argument(index = 0, name = "name", description = "Probe Name", required = true, multiValued = false)
    private String name;

    @Option(name = "-s", aliases = "--start", description = "Start the Probe at once", required = false, multiValued = false)
    private Boolean startProbe = false;

    @Option(name = "-p", aliases = "--period", description = "Execution period in seconds", required = false, multiValued = false)
    private Integer period = 10;

    @Option(name = "-i", aliases = "--indicators", description = "List of indicators", required = true, multiValued = true)
    private List<String> indicators;

    @Option(name = "-o", aliases = "--outputs", description = "List of outputs", required = false, multiValued = true)
    private List<String> outputs;

    @Option(name = "-t", aliases = "--targets", description = "List of targets", required = false, multiValued = true)
    private List<String> targets;

    protected static Log logger = LogFactory.getLog(Util.class);

    public Object execute(CommandSession commandSession) {

        logger.debug("");

        try {
            // create JasmineProbe
            JasmineProbe n = new JasmineProbe();
            n.setId(name);
            n.setPeriod(period);
            n.setIndicatorList(indicators);
            if (outputs != null) {
                n.setOutputList(outputs);
            }
            if (targets != null) {
                n.setTargetList(targets);
            }
            probeManager.createProbe(n);
            logger.info("Create " + name + " successful");
        } catch (Exception e) {
            logger.error("Create " + name + " failed", e);
            return null;
        }

        // start probe
        if (startProbe) {
            try {
                probeManager.startProbe(name);
                logger.info("probe " + name + " started");
            } catch (Exception e) {
                logger.error("Starting probe " + name + " failed", e);
            }
        }
        return null;
    }

}