/**
 * JASMINe
 * Copyright (C) 2013 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 */

package org.ow2.jasmine.probe.shell;

import org.apache.felix.gogo.commands.Action;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.HandlerDeclaration;
import org.apache.felix.ipojo.annotations.Requires;
import org.apache.felix.service.command.CommandSession;
import org.ow2.jasmine.probe.JasmineProbe;
import org.ow2.jasmine.probe.JasmineProbeManager;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

import java.util.Collection;

/**
 * Shell command: probe-list
 *
 * @author durieuxp
 */
@Component
@Command(name = "probe-list",
        scope = "jasmine",
        description = "List JASMINe probes")
@HandlerDeclaration("<sh:command xmlns:sh='org.ow2.shelbie'/>")
public class ProbeList implements Action {

    @Requires
    JasmineProbeManager probeManager = null;

    @Argument(index = 0, name = "name", description = "Probe Name", required = false, multiValued = false)
    private String name;

    @Option(name = "-v", aliases = "--verbose", description = "If true, print details about probes", required = false, multiValued = false)
    private Boolean verbose = false;

    protected static Log logger = LogFactory.getLog(Util.class);

    public Object execute(CommandSession commandSession) {

        logger.debug("");
        try {
            if (name == null) {
                // List all probes
                Collection<JasmineProbe> objs = probeManager.getProbes();
                if (objs.isEmpty()) {
                    logger.error("There are no JasmineProbes");
                    return null;
                }
                for (JasmineProbe obj : objs) {
                    if (verbose) {
                        System.out.println(obj.toLine());
                    } else {
                        System.out.println(obj.getId());
                    }
                }
            } else {
                // Show one Object
                JasmineProbe obj = probeManager.getProbe(name);
                System.out.println(obj.toString());
            }
        } catch (Exception e) {
            logger.error("probe-list failed: ", e);
        }
        return null;
    }


}