/**
 * JASMINe
 * Copyright (C) 2013 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 */

package org.ow2.jasmine.probe.shell;

/**
 * Utilities for shell commands
 *
 * @author durieuxp
 */
public class Util {

    /**
     * Verify that the command parameter has the following format : paramName=paramValue
     *
     * @param param
     * @return true if format ok, false if the format is wrong
     */
    static protected boolean validParam(String param) {
        int indexEqual = param.indexOf("=");
        if (indexEqual == -1) {
            // there is no = sign
            return false;
        } else if (indexEqual < 1) {
            // there is no paramName before the =
            return false;
        } else {
            try {
                param.substring(indexEqual + 1);
                return true;
            } catch (IndexOutOfBoundsException obe) {
                // there is no paramValue after the =
                return false;
            }
        }
    }

}
