/**
 * JASMINe
 * Copyright (C) 2011 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id$
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.probe.util.internal;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularType;

import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.Invalidate;
import org.apache.felix.ipojo.annotations.Provides;
import org.apache.felix.ipojo.annotations.Requires;
import org.apache.felix.ipojo.annotations.Validate;
import org.ow2.jasmine.probe.util.UtilService;
import org.ow2.jonas.jmx.JmxService;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

@Component(name="UtilService")
@Provides
public class UtilServiceImpl implements UtilService {

    private Log logger = LogFactory.getLog(UtilService.class);


    /**
     * JOnAS JMX Service reference.
     */
    @Requires
    private JmxService jmxService = null;

    /**
     * Start the ipojo
     */
    @Validate
    public void start() {
        logger.debug("");
        if (jmxService != null) {
            System.out.println("Got Jmx Service");
            MBeanServerConnection jmxCnx = jmxService.getJmxServerConnection();
            try {
                int nbMBeans = jmxCnx.getMBeanCount();
                System.out.println("Got access to local Jmx Server. Found " + nbMBeans + " mbeans.");
                String name = "java.lang:type=Threading";
                name = "java.lang:type=Memory";
                name = "java.lang:type=GarbageCollector,name=PS MarkSweep";
                ObjectName on = null;
                try {
                    on = getOn(name, jmxCnx);
                } catch (MalformedObjectNameException e) {
                    // TODO Auto-generated catch block
                    e.printStackTrace();
                } catch (NullPointerException e) {
                    // TODO Auto-generated catch block
                    e.printStackTrace();
                }
                // Test attribute metrics
                String attName = "ThreadCount";
                attName = "LastGcInfo";
                attName = "ObjectPendingFinalizationCount";
                attName = "Verbose";
                attName = "NonHeapMemoryUsage";
                attName = "MemoryPoolNames";
                attName = "CollectionCount";
                getMetrics(on, attName, jmxCnx);
                attName = "CollectionTime";
                getMetrics(on, attName, jmxCnx);
                attName = "MemoryPoolNames";
                getMetrics(on, attName, jmxCnx);
                attName = "LastGcInfo";
                getMetrics(on, attName, jmxCnx);
                // Test fragment metrics
                String frgName = "MemoryPoolNames[0]";
                getMetrics(on, frgName, jmxCnx);
                frgName = "LastGcInfo.GcThreadCount";
                getMetrics(on, frgName, jmxCnx);
                frgName = "LastGcInfo.GcThreadCount";
                getMetrics(on, frgName, jmxCnx);
                frgName = "LastGcInfo.memoryUsageAfterGc[PS Survivor Space].value.committed";
                getMetrics(on, frgName, jmxCnx);
            } catch (IOException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }
        }
    }

    /**
     * Stop the ipojo
     */
    @Invalidate
    public void stop() {
        logger.debug("");
    }

    private ArrayList<ObjectName> getOns(String name, MBeanServerConnection jmxCnx) throws MalformedObjectNameException, NullPointerException, IOException {
        ObjectName ons = ObjectName.getInstance(name);
        Set<ObjectName> onset = jmxCnx.queryNames(ons, null);
        ArrayList<ObjectName> onlist = new ArrayList<ObjectName>(onset);
        return onlist;
    }

    private ObjectName getOn(String name, MBeanServerConnection jmxCnx) throws MalformedObjectNameException, NullPointerException, IOException {
        int index = 0;
        ArrayList<ObjectName> onlist = getOns(name, jmxCnx);
        if (onlist.isEmpty()) {
            return null;
        }
        return onlist.get(index);
    }

    /**
     * Get all the metrics for a given MBean attribute or fragment at the moment of the call.
     * If the attribute or the fragment has a simple value, only one metric is returned.
     * Otherwise, a list of metrics corresponding its fragments having simple types is returned.
     * @param on MBean ObjectName
     * @param name attribute or fragment name
     * @param jmxCnx
     * @return One or more metrics.
     */
    private List<Metric> getMetrics(ObjectName on, String name, MBeanServerConnection jmxCnx) {
        ArrayList<Metric> metrics = new ArrayList<Metric>();
        if (isAttributeName(name, on, jmxCnx)) {
            // treat case accessing an attribute's values
            try {
                Object attribute = jmxCnx.getAttribute(on, name);
                long time = System.currentTimeMillis();
                Metric metric = Metric.getMetric(on, name, time, attribute);
                if (metric != null) {
                    // ok its a simple type
                    metrics.add(metric);
                    System.out.println(metric.toString());
                    return metrics;
                } else {
                    // complex types
                    return Metric.getMetrics(on, name, time, attribute);
                }
            } catch (AttributeNotFoundException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            } catch (InstanceNotFoundException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            } catch (MBeanException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            } catch (ReflectionException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            } catch (IOException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }
        } else {
            String attributeName = isFragmentName(name, on, jmxCnx);
            if (attributeName == null) {
                System.out.println(name + " is not a well formed fragment name");
            } else {
                // till now this is an OK fragment name of attribute attributeName
                // try to read attribute
                /*
                try {
                    Object attribute = jmxCnx.getAttribute(on, attributeName);
                    long time = System.currentTimeMillis();
                    Metric metric = Metric.getMetricFromFragment(on, name, time, attribute);
                    if (metric != null) {
                        // ok its a simple type
                        metrics.add(metric);
                        System.out.println(metric.toString());
                        return metrics;
                    } else {
                        // complex types
                        return Metric.getMetrics(on, name, time, attribute);
                    }
                } catch (AttributeNotFoundException e) {
                    // TODO Auto-generated catch block
                    e.printStackTrace();
                } catch (InstanceNotFoundException e) {
                    // TODO Auto-generated catch block
                    e.printStackTrace();
                } catch (MBeanException e) {
                    // TODO Auto-generated catch block
                    e.printStackTrace();
                } catch (ReflectionException e) {
                    // TODO Auto-generated catch block
                    e.printStackTrace();
                } catch (IOException e) {
                    // TODO Auto-generated catch block
                    e.printStackTrace();
                }*/

            }
        }
        return metrics;
    }




    // Naming policy
    // ------------

    private boolean isAttributeName(String name, ObjectName on, MBeanServerConnection jmxCnx) {
        try {
            MBeanInfo mbeanInfo = jmxCnx.getMBeanInfo(on);
            MBeanAttributeInfo[] attsInfo = mbeanInfo.getAttributes();
            for (MBeanAttributeInfo attInfo : attsInfo) {
                if (name.equals(attInfo.getName())) {
                    return true;
                }
            }
        } catch (InstanceNotFoundException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        } catch (IntrospectionException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        } catch (ReflectionException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        } catch (IOException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
        return false;
    }

    /**
     * A fragment name has the following format:
     * attName.something... or attName[indexes]....
     * @param name supposed fragment name
     * @param on
     * @param jmxCnx
     * @return
     */
    private String isFragmentName(String name, ObjectName on, MBeanServerConnection jmxCnx) {
        String attName = null;
        int dotIndex = name.indexOf(FragmentName.DOT);
        int brackleftIndex = name.indexOf(FragmentName.brackleft);
        int brackrightIndex = name.indexOf(FragmentName.brackright);
        if (dotIndex < 0) {
            // no dot, check for brackets
            if (brackleftIndex > 0 && brackrightIndex > 0 && brackleftIndex < brackrightIndex) {
                // attName[..]
                attName = name.substring(0, brackleftIndex);
            }
        } else if (dotIndex > 0) {
            // Got a dot, check for brackets
            if (brackleftIndex > 0 && brackrightIndex > 0 && brackleftIndex < brackrightIndex) {
                // got dot and brackets
                if (dotIndex < brackleftIndex) {
                    // dot before brackets
                    attName = name.substring(0, dotIndex);
                } else {
                    // brackets before dot
                    attName = name.substring(0, brackleftIndex);
                }
            } else {
                // no brackets
                attName = name.substring(0, dotIndex);
            }
        }
        if (attName != null) {
            if (isAttributeName(attName, on, jmxCnx)) {
                System.out.println(name + " is a fragment of " + attName + " attribute (MBean " + on + ")");
                return attName;
            } else {
                // the attName is not an attribute name ... ???
                System.out.println(name + " seems to be a fragment, but MBean " + on + " has no attribute named " + attName);
                return null;
            }
        }
        return attName;
    }

}
