/**
 * JASMINe
 * Copyright (C) 2011 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id$
 * --------------------------------------------------------------------------
 */
 
package org.ow2.jasmine.probe.itests;


import java.io.FileReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.ow2.jasmine.probe.JasmineIndicator;
import org.ow2.jasmine.probe.JasmineOutput;
import org.ow2.jasmine.probe.JasmineProbe;
import org.ow2.jasmine.probe.JasmineProbeException;

import au.com.bytecode.opencsv.CSVReader;

import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class IndicatorLewysTest extends JOnASLauncher {

    // TODO: WARNING: This test class IN NOT UP TO DATE .....

    private static boolean isLinux = false;
    /**
     * 
     * @throws Exception
     */
    
    @BeforeClass
    public void setOsType() throws Exception {
        if ("Linux".equals(System.getProperty("os.name"))) {
            isLinux = true;
        }
    }

    @Test
    public void testTargetAgent0() throws Exception {
        logger.debug(">> testTargetAgent0");
        final String targetName = "agent0";
        try {
            getProxyMXBean().getTarget(targetName);
        } catch (JasmineProbeException e) {
            Assert.fail("The target '" + targetName + "' is not defined");
        }
    }

    @Test
    public void testIndicatorCreateLewysKernelLinux() throws Exception {
        logger.debug(">> testIndicatorCreateLewysKernelLinux");
        if (isLinux) {
            final String name = "tst_KernelLinux";
            // creation
            JasmineIndicator indicatorLewysKernelLinux = new JasmineIndicator();
            indicatorLewysKernelLinux.setName(name);
            indicatorLewysKernelLinux.setType("lewys");
            Map<String,String> props = new HashMap<String,String>();
            props.put("cmd", "kernel");
            props.put("resources", "Interrupts,Context switches,Processes");
            indicatorLewysKernelLinux.setProperties(props);
            getProxyMXBean().createIndicator(indicatorLewysKernelLinux);
            // check
            JasmineIndicator ji = getProxyMXBean().getIndicator(name);
            Assert.assertEquals(ji.getName(), name, "Invalid indicator name. (Actual = " + ji.getName() + ", Expected = " + name + ")");
            Assert.assertEquals(ji.getType(), "lewys", "Invalid indicator type. (Actual = " + ji.getType() + ", Expected = df)");
            Map<String, String> propsActual = ji.getProperties();
            Assert.assertEquals(propsActual.size(), 2, "Invalid indicator properties size. (Actual = " + propsActual.size() + ", Expected = 2)");
        } else {
            logger.info(">> testIndicatorCreateLewysKernelLinux skipped");
        }
    }

    @Test
    public void testOutputFileCreateLewysKernelLinux() throws Exception {
        logger.debug(">> testOutputFileCreateLewysKernelLinux");
        if (isLinux) {
            final String name = "tst_KernelLinux";
            // creation
            final String fileName = getTmpDirPath() + name + ".csv";
            JasmineOutput outputDfAll = new JasmineOutput();
            outputDfAll.setName(name);
            outputDfAll.setType("file");
            Map<String, String> props = new HashMap<String, String>();
            props.put("path", fileName);
            outputDfAll.setProperties(props);
            getProxyMXBean().createOutput(outputDfAll);
            // check
            JasmineOutput jo = getProxyMXBean().getOutput(name);
            Assert.assertEquals(jo.getName(), name, "Invalid output name. (Actual = " + jo.getName() + ", Expected = " + name + ")");
            Assert.assertEquals(jo.getType(), "file", "Invalid output type. (Actual = " + jo.getType() + ", Expected = file)");
            Map<String, String> propsActual = jo.getProperties();
            Assert.assertEquals(propsActual.size(), 1, "Invalid output properties size. (Actual = " + propsActual.size() + ", Expected = 1)");
            Assert.assertEquals(propsActual.get("path"), fileName, "Invalid output properties values. (Actual = " + propsActual.get("path") + ", Expected = " + fileName + ")");
        } else {
            logger.info(">> testOutputFileCreateLewysKernelLinux skipped");
        }
    }

    @Test(dependsOnMethods={"testTargetAgent0","testIndicatorCreateLewysKernelLinux","testOutputFileCreateLewysKernelLinux"})
    public void testProbeCreateLewysKernelLinux() throws Exception {
        logger.debug(">> testProbeCreateLewysKernelLinux");
        if (isLinux) {
            final String name = "tst_KernelLinux";
            // creation
            final int period = 1;
            JasmineProbe probeLewysKernelLinux = new JasmineProbe();
            probeLewysKernelLinux.setId(name);
            List<String> ji = new ArrayList<String>(Arrays.asList(name));
            probeLewysKernelLinux.setIndicatorList(ji);
            List<String> jo = new ArrayList<String>(Arrays.asList(name));
            probeLewysKernelLinux.setOutputList(jo);
            List<String> jt = new ArrayList<String>(Arrays.asList("agent0"));
            probeLewysKernelLinux.setTargetList(jt);
            probeLewysKernelLinux.setPeriod(period);
            getProxyMXBean().createProbe(probeLewysKernelLinux);
            // check
            JasmineProbe jp = getProxyMXBean().getProbe(name);
            Assert.assertEquals(jp.getId(), name , "Invalid probe id. (Actual = " + jp.getId() + ", Expected = " + name + ")");
            Assert.assertEquals(jp.getId(), name , "Invalid probe id. (Actual = " + jp.getId() + ", Expected = " + name + ")");
            Assert.assertEquals(jp.getPeriod(), period , "Invalid probe period. (Actual = " + jp.getPeriod() + ", Expected = " + period + ")");
            Assert.assertEquals(jp.getStatus(), JasmineProbe.PROBE_STOPPED , "Invalid probe status. (Actual = " + jp.getStatus() + ", Expected = " + JasmineProbe.PROBE_STOPPED + ")");
        } else {
            logger.info(">> testProbeCreateLewysKernelLinux skipped");
        }
    }

    @Test(dependsOnMethods={"testProbeCreateLewysKernelLinux"})
    public void testProbeStartStopLewysKernelLinux() throws Exception {
        logger.debug(">> testProbeStartStopLewysKernelLinux");
        // start the probe LewysKernelLinux
        final String name = "tst_KernelLinux";
        final int period = 1;
        final String fileName = getTmpDirPath() + name + ".csv";
        getProxyMXBean().startProbe(name);
        // Check the probe status
        JasmineProbe jp = getProxyMXBean().getProbe(name);
        if ((jp.getStatus() != JasmineProbe.PROBE_STARTED) && (jp.getStatus() != JasmineProbe.PROBE_RUNNING)) {
            Assert.fail("Invalid probe status (Actual = " + jp.printStatus() + ", Expected = STARTED|RUNNING)");
        }
        // Wait some collects ...
        Thread.sleep(period*1000*2);
        // stop the probe
        getProxyMXBean().stopProbe(name);
        // Check the probe status
        jp = getProxyMXBean().getProbe(name);
        Assert.assertEquals(jp.getStatus(), JasmineProbe.PROBE_STOPPED , "Invalid probe status. (Actual = " + jp.getStatus() + ", Expected = " + JasmineProbe.PROBE_STOPPED + ")");
        // Check the output file content
        // - not empty
        // - TODO: more checking
        CSVReader reader = null;
        boolean emptyOutput = true;
        try {
            reader = new CSVReader(new FileReader(fileName), ';');
            while ((reader.readNext()) != null) {
                // nextLine[] is an array of values from the line
                emptyOutput = false;
            }
        } finally {
            if (reader != null) {
                reader.close();
            }
        }
        Assert.assertFalse(emptyOutput, "There is no collects for the probe " + name);
    }
    
}
