/**
* JASMINe
* Copyright (C) 2012 Bull S.A.S.
* Contact: jasmine@ow2.org
*
* This library is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or any later version.
*
* This library is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this library; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
* USA
*
* --------------------------------------------------------------------------
* $Id$
* --------------------------------------------------------------------------
*/

package org.ow2.jasmine.probe.itests;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.ArrayList;


import org.ow2.jasmine.probe.JasmineProbeException;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;

public class CnfFelixShStructuredAttrIndicatorTest extends AbsStructuredAttrIndicatorTest {

    @BeforeClass
     public void createProbesAndWait()  throws InterruptedException, JasmineProbeException {

        String felixShIP = System.getProperty("osgi.shell.telnet.ip", "localhost");
        String felixShPort = System.getProperty("osgi.shell.telnet.port", "6666");
        
        logger.info("Felix shell remote on " + felixShIP + ":" + felixShPort);
        

        ArrayList<String> cmdList = new ArrayList<String>();
        cmdList.add("target-create -u " + getJmxUrl() + " tst_agent1");
        cmdList.add("output-create -t console stdio1");           
        cmdList.add("output-create  -t file -d path="+getTmpDirPath()+"tst1_Logging_SomeLoggerNames.csv tst1_Logging_SomeLoggerNames");
        cmdList.add("output-create  -t file -d path="+getTmpDirPath()+"tst1_Threading_SomeThreadIds.csv tst1_Threading_SomeThreadIds");
        cmdList.add("output-create  -t file -d path="+getTmpDirPath()+"tst1_Memory_XMemoryUsage_used.csv tst1_Memory_XMemoryUsage_used");
        cmdList.add("output-create  -t file -d path="+getTmpDirPath()+"tst1_Runtime_SystemProperties_jonas_name_value.csv tst1_Runtime_SystemProperties_jonas_name_value");
        cmdList.add("output-create  -t file -d path="+getTmpDirPath()+"tst1_Complex_hjo.csv tst1_Complex_hjo");
        cmdList.add("output-create  -t file -d path="+getTmpDirPath()+"tst1_Complex_hjo_person.csv tst1_Complex_hjo_person");
        cmdList.add("output-create  -t file -d path="+getTmpDirPath()+"tst1_Complex_hjo_person_firstname.csv tst1_Complex_hjo_person_firstname");
        cmdList.add("output-create  -t file -d path="+getTmpDirPath()+"tst1_Complex_hjo_person_address_city.csv tst1_Complex_hjo_person_address_city");
        cmdList.add("output-create  -t file -d path="+getTmpDirPath()+"tst1_Complex_hjo_person_children_0.csv tst1_Complex_hjo_person_children_0");
        cmdList.add("output-create  -t file -d path="+getTmpDirPath()+"tst1_Complex_hjo_string_array.csv tst1_Complex_hjo_string_array");
        cmdList.add("output-create  -t file -d path="+getTmpDirPath()+"tst1_Complex_hjo_string_array_some.csv tst1_Complex_hjo_string_array_some");
        cmdList.add("output-create  -t file -d path="+getTmpDirPath()+"tst1_Complex_hjo_int_array.csv tst1_Complex_hjo_int_array");
        cmdList.add("output-create  -t file -d path="+getTmpDirPath()+"tst1_Complex_hjo_int_array_some.csv tst1_Complex_hjo_int_array_some");
        cmdList.add("output-create  -t file -d path="+getTmpDirPath()+"tst1_Complex_hjo_tabular_simple.csv tst1_Complex_hjo_tabular_simple");
        cmdList.add("output-create  -t file -d path="+getTmpDirPath()+"tst1_Complex_hjo_tabular_simple_some.csv tst1_Complex_hjo_tabular_simple_some");
        cmdList.add("output-create  -t file -d path="+getTmpDirPath()+"tst1_Complex_hjo_struct_one_field.csv tst1_Complex_hjo_struct_one_field");
        cmdList.add("output-create  -t file -d path="+getTmpDirPath()+"tst1_Complex_hjo_long_array_one_elt.csv tst1_Complex_hjo_long_array_one_elt ");
        cmdList.add("indicator-create -t jmx -d target=tst_agent1 -d mbean=java.util.logging:type=Logging -d attr=LoggerNames[0],LoggerNames[3] tst1_Logging_SomeLoggerNames");
        cmdList.add("indicator-create -t jmx -d target=tst_agent1 -d mbean=java.lang:type=Threading -d attr=AllThreadIds[0],AllThreadIds[5] tst1_Threading_SomeThreadIds");
        cmdList.add("indicator-create -t jmx -d target=tst_agent1 -d mbean=java.lang:type=Memory -d attr=HeapMemoryUsage.used,NonHeapMemoryUsage.used tst1_Memory_XMemoryUsage_used");
        cmdList.add("indicator-create -t jmx -d target=tst_agent1 -d mbean=java.lang:type=Runtime -d attr=SystemProperties[jonas.name].value tst1_Runtime_SystemProperties_jonas_name_value");
        cmdList.add("indicator-create -t jmx -d target=tst_agent1 -d mbean=*:type=Complex,name=hjo -d attr=all tst1_Complex_hjo");
        cmdList.add("indicator-create -t jmx -d target=tst_agent1 -d mbean=*:type=Complex,name=hjo -d attr=Person tst1_Complex_hjo_person");
        cmdList.add("indicator-create -t jmx -d target=tst_agent1 -d mbean=*:type=Complex,name=hjo -d attr=Person.firstName tst1_Complex_hjo_person_firstname");
        cmdList.add("indicator-create -t jmx -d target=tst_agent1 -d mbean=*:type=Complex,name=hjo -d attr=Person.address.city tst1_Complex_hjo_person_address_city");
        cmdList.add("indicator-create -t jmx -d target=tst_agent1 -d mbean=*:type=Complex,name=hjo -d attr=Person.children[0] tst1_Complex_hjo_person_children_0");
        cmdList.add("indicator-create -t jmx -d target=tst_agent1 -d mbean=*:type=Complex,name=hjo -d attr=StringArray tst1_Complex_hjo_string_array");
        cmdList.add("indicator-create -t jmx -d target=tst_agent1 -d mbean=*:type=Complex,name=hjo -d attr=StringArray[0],StringArray[1] tst1_Complex_hjo_string_array_some");
        cmdList.add("indicator-create -t jmx -d target=tst_agent1 -d mbean=*:type=Complex,name=hjo -d attr=IntArray tst1_Complex_hjo_int_array");
        cmdList.add("indicator-create -t jmx -d target=tst_agent1 -d mbean=*:type=Complex,name=hjo -d attr=IntArray[0] tst1_Complex_hjo_int_array_some");
        cmdList.add("indicator-create -t jmx -d target=tst_agent1 -d mbean=*:type=Complex,name=hjo -d attr=TabularSimple tst1_Complex_hjo_tabular_simple");
        cmdList.add("indicator-create -t jmx -d target=tst_agent1 -d mbean=*:type=Complex,name=hjo -d attr=TabularSimple[lastName].value tst1_Complex_hjo_tabular_simple_some");
        cmdList.add("indicator-create -t jmx -d target=tst_agent1 -d mbean=*:type=Complex,name=hjo -d attr=StructOneField tst1_Complex_hjo_struct_one_field");
        cmdList.add("indicator-create -t jmx -d target=tst_agent1 -d mbean=*:type=Complex,name=hjo -d attr=LongArrayOneElt tst1_Complex_hjo_long_array_one_elt ");
        cmdList.add("probe-create -s -p 3 -o tst1_Logging_SomeLoggerNames -i tst1_Logging_SomeLoggerNames ptst1_Logging_SomeLoggerNames");
        cmdList.add("probe-create -s -p 3 -o tst1_Threading_SomeThreadIds -i tst1_Threading_SomeThreadIds ptst1_Threading_SomeThreadIds");
        cmdList.add("probe-create -s -p 3 -o tst1_Memory_XMemoryUsage_used -i tst1_Memory_XMemoryUsage_used ptst1_Memory_XMemoryUsage_used");
        cmdList.add("probe-create -s -p 3 -o tst1_Runtime_SystemProperties_jonas_name_value -i tst1_Runtime_SystemProperties_jonas_name_value ptst1_Runtime_SystemProperties_jonas_name_value");
        cmdList.add("probe-create -s -p 3 -o tst1_Complex_hjo -i tst1_Complex_hjo ptst1_Complex_hjo");
        cmdList.add("probe-create -s -p 3 -o tst1_Complex_hjo_person -i tst1_Complex_hjo_person ptst1_Complex_hjo_person");
        cmdList.add("probe-create -s -p 3 -o tst1_Complex_hjo_person_firstname -i tst1_Complex_hjo_person_firstname ptst1_Complex_hjo_person_firstname");
        cmdList.add("probe-create -s -p 3 -o tst1_Complex_hjo_person_address_city -i tst1_Complex_hjo_person_address_city ptst1_Complex_hjo_person_address_city");
        cmdList.add("probe-create -s -p 3 -o tst1_Complex_hjo_person_children_0 -i tst1_Complex_hjo_person_children_0 ptst1_Complex_hjo_person_children_0");
        cmdList.add("probe-create -s -p 3 -o tst1_Complex_hjo_string_array -i tst1_Complex_hjo_string_array ptst1_Complex_hjo_string_array");
        cmdList.add("probe-create -s -p 3 -o tst1_Complex_hjo_string_array_some -i tst1_Complex_hjo_string_array_some ptst1_Complex_hjo_string_array_some");
        cmdList.add("probe-create -s -p 3 -o tst1_Complex_hjo_int_array -i tst1_Complex_hjo_int_array ptst1_Complex_hjo_int_array");
        cmdList.add("probe-create -s -p 3 -o tst1_Complex_hjo_int_array_some -i tst1_Complex_hjo_int_array_some ptst1_Complex_hjo_int_array_some");
        cmdList.add("probe-create -s -p 3 -o tst1_Complex_hjo_tabular_simple -i tst1_Complex_hjo_tabular_simple ptst1_Complex_hjo_tabular_simple");
        cmdList.add("probe-create -s -p 3 -o tst1_Complex_hjo_tabular_simple_some -i tst1_Complex_hjo_tabular_simple_some ptst1_Complex_hjo_tabular_simple_some");
        cmdList.add("probe-create -s -p 3 -o tst1_Complex_hjo_struct_one_field -i tst1_Complex_hjo_struct_one_field ptst1_Complex_hjo_struct_one_field");
        cmdList.add("probe-create -s -p 3 -o tst1_Complex_hjo_long_array_one_elt -i tst1_Complex_hjo_long_array_one_elt ptst1_Complex_hjo_long_array_one_elt ");


        cmdList.add("target-list");
        cmdList.add("output-list");
        cmdList.add("indicator-list");
        cmdList.add("probe-list");

        
        Socket socketFelixSh = null;
        PrintWriter sOut = null;

        try {
            
            socketFelixSh = new Socket(felixShIP, Integer.parseInt(felixShPort));
            sOut = new PrintWriter(socketFelixSh.getOutputStream(), true);

            for(String cmd: cmdList) {
                logger.info("-> " + cmd);
                sOut.println(cmd);
                // TODO: Some tests randomly fail if there is not this following wait.
                // To be studied ...
                Thread.sleep(300);
            }

        } catch (IOException ioe) {
            Assert.fail("Error when creating outputs/indicators/probes", ioe);
            
        } finally {
            try {
                if (sOut  != null) {
                    sOut.close();
                }
                if (socketFelixSh != null) {
                    socketFelixSh.close();
                } 
            } catch (IOException ioe) {
                // ignore
            }
        }

        logger.info("The indicators/probes have been probably successfully created via Felix Shell");

        // Wait few mn to get the time to do some collects .... and than stop all the probes
        logger.info("Wait " + WAIT_COLLECTS_IN_SEC + " sec to get time to do some collects ...");
        Thread.sleep(WAIT_COLLECTS_IN_SEC*1000);
        getProxyMXBean().stopAllProbes();
        
    }

}
