/**
* JASMINe
* Copyright (C) 2012 Bull S.A.S.
* Contact: jasmine@ow2.org
*
* This library is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or any later version.
*
* This library is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this library; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
* USA
*
* --------------------------------------------------------------------------
* $Id$
* --------------------------------------------------------------------------
*/

package org.ow2.jasmine.probe.itests;

import java.util.ArrayList;

import org.ow2.jasmine.probe.JasmineProbeException;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;

public class CnfJmxProcessingIndicatorTest extends AbsProcessingIndicatorTest {

   @BeforeClass
   public void createProbesAndWait() throws InterruptedException, JasmineProbeException {
       try {

           String cmdBegin = "java -jar " + getJmxClientJarName() + " -port " + getPortNumber() + " -server " + getServerName() +" ";
           logger.info("Exec of: " + cmdBegin + "...");

           ArrayList<String> cmdList = new ArrayList<String>();

           cmdList.add("target-create tst_agent0 -u " + getJmxUrl());
           cmdList.add("target-create tst_agent_unknown -u service:jmx:rmi:///jndi/rmi://localhost:"+getPortNumber()+"/jrmpconnector_unknown  ");
           cmdList.add("output-create stdio -t console");
           cmdList.add("output-create tst_mbdefault_all_attributes -t file path="+getTmpDirPath()+"/tst_mbdefault_all_attributes.csv");
           cmdList.add("output-create tst_mb_aa_01_delta -t file path="+getTmpDirPath()+"tst_mb_aa_01_delta.csv");
           cmdList.add("output-create tst_mb_aa_02_rate -t file path="+getTmpDirPath()+"tst_mb_aa_02_rate.csv");
           cmdList.add("output-create tst_mb_aa_03_slope -t file path="+getTmpDirPath()+"tst_mb_aa_03_slope.csv");
           cmdList.add("output-create tst_mb_aa_04_add -t file path="+getTmpDirPath()+"tst_mb_aa_04_add.csv");
           cmdList.add("output-create tst_mb_aa_04_sub -t file path="+getTmpDirPath()+"tst_mb_aa_04_sub.csv");
           cmdList.add("output-create tst_mb_aa_04_mul -t file path="+getTmpDirPath()+"tst_mb_aa_04_mul.csv");
           cmdList.add("output-create tst_mb_aa_04_div -t file path="+getTmpDirPath()+"tst_mb_aa_04_div.csv");
           cmdList.add("output-create tst_mb_aa_04_percent -t file path="+getTmpDirPath()+"tst_mb_aa_04_percent.csv");
           cmdList.add("output-create tst_mb_aa_04_add_complex -t file path="+getTmpDirPath()+"tst_mb_aa_04_add_complex.csv");
           cmdList.add("output-create tst_mb_aa_04_mul_complex -t file path="+getTmpDirPath()+"tst_mb_aa_04_mul_complex.csv");
           cmdList.add("output-create tst_mb_ab_xx_correlate -t file path="+getTmpDirPath()+"tst_mb_ab_xx_correlate.csv");
           cmdList.add("output-create tst_mb_ac_01_merge -t file path="+getTmpDirPath()+"tst_mb_ac_01_merge.csv");
           cmdList.add("output-create tst_mb_ac_xx_merge_one -t file path="+getTmpDirPath()+"tst_mb_ac_xx_merge_one.csv");
           cmdList.add("output-create tst_mbdefault_target_on_probe -t file path="+getTmpDirPath()+"tst_mbdefault_target_on_probe.csv");
           cmdList.add("output-create tst_mb_aa_04_add_float -t file path="+getTmpDirPath()+"tst_mb_aa_04_add_float.csv");
           cmdList.add("output-create tst_mb_aa_04_sub_float -t file path="+getTmpDirPath()+"tst_mb_aa_04_sub_float.csv");
           cmdList.add("output-create tst_mb_aa_04_mul_float -t file path="+getTmpDirPath()+"tst_mb_aa_04_mul_float.csv");
           cmdList.add("output-create tst_mb_ac_xx_merge_float -t file path="+getTmpDirPath()+"tst_mb_ac_xx_merge_float.csv");
           cmdList.add("output-create tst_mb_aa_05_BUG133_several_use_indicator -t file path="+getTmpDirPath()+"tst_mb_aa_05_BUG133_several_use_indicator.csv");
           cmdList.add("output-create tst_mb_aa_05_BUG145_several_use_indicator -t file path="+getTmpDirPath()+"tst_mb_aa_05_BUG145_several_use_indicator.csv");
           cmdList.add("output-create tst_mb_aa_06_cache_several_use_indicator -t file path="+getTmpDirPath()+"tst_mb_aa_06_cache_several_use_indicator.csv");
           cmdList.add("output-create tst_mb_bb_xx_delta_rate_slope -t file path="+getTmpDirPath()+"tst_mb_bb_xx_delta_rate_slope.csv");
           cmdList.add("output-create tst_df_all_several_use_indicator -t file path="+getTmpDirPath()+"tst_df_all_several_use_indicator.csv  ");
           cmdList.add("indicator-create tst_C_1 -t constant type=int value=1");
           cmdList.add("indicator-create tst_C_2 -t constant type=int value=2");
           cmdList.add("indicator-create tst_C_15 -t constant type=int value=15");
           cmdList.add("indicator-create tst_mbdefault_all_attributes -t jmx target=tst_agent0 mbean=*:type=Basic,category=default,name=mbdefault attr=all test=true");
           cmdList.add("indicator-create tst_mb_aa_01_CIncrement -t jmx target=tst_agent0 mbean=*:type=Basic,category=aa,name=mb_aa_01 attr=CIncrement test=true");
           cmdList.add("indicator-create tst_mb_aa_01_VIncremented -t jmx target=tst_agent0 mbean=*:type=Basic,category=aa,name=mb_aa_01 attr=VIncremented test=true");
           cmdList.add("indicator-create tst_mb_aa_01_delta_VIncremented -t derived op=delta -i tst_mb_aa_01_VIncremented");
           cmdList.add("indicator-create tst_mb_aa_02_CIncrement -t jmx target=tst_agent0 mbean=*:type=Basic,category=aa,name=mb_aa_02 attr=CIncrement test=true");
           cmdList.add("indicator-create tst_mb_aa_02_VIncremented -t jmx target=tst_agent0 mbean=*:type=Basic,category=aa,name=mb_aa_02 attr=VIncremented test=true");
           cmdList.add("indicator-create tst_mb_aa_02_rate_VIncremented -t derived op=rate -i tst_mb_aa_02_VIncremented");
           cmdList.add("indicator-create tst_mb_aa_03 -t jmx target=tst_agent0 mbean=*:type=Basic,category=aa,name=mb_aa_03 attr=CIncrement,CStep test=true");
           cmdList.add("indicator-create tst_mb_aa_03_VIncremented -t jmx target=tst_agent0 mbean=*:type=Basic,category=aa,name=mb_aa_03 attr=VIncremented test=true");
           cmdList.add("indicator-create tst_mb_aa_03_VSinusoidal -t jmx target=tst_agent0 mbean=*:type=Basic,category=aa,name=mb_aa_03 attr=VSinusoidal test=true");
           cmdList.add("indicator-create tst_mb_aa_03_slope_VIncremented_VSinusoidal -t slope -i tst_mb_aa_03_VIncremented -i tst_mb_aa_03_VSinusoidal");
           cmdList.add("indicator-create tst_mb_aa_04_CInt1 -t jmx target=tst_agent0 mbean=*:type=Basic,category=aa,name=mb_aa_04 attr=CInt1 test=true");
           cmdList.add("indicator-create tst_mb_aa_04_CInt2 -t jmx target=tst_agent0 mbean=*:type=Basic,category=aa,name=mb_aa_04 attr=CInt2 test=true");
           cmdList.add("indicator-create tst_mb_aa_04_add_CInt1_CInt2 -t correlate op=add -i tst_mb_aa_04_CInt1 -i tst_mb_aa_04_CInt2");
           cmdList.add("indicator-create tst_mb_aa_04_sub_CInt1_CInt2 -t correlate op=sub -i tst_mb_aa_04_CInt1 -i tst_mb_aa_04_CInt2");
           cmdList.add("indicator-create tst_mb_aa_04_mul_CInt1_CInt2 -t correlate op=mul -i tst_mb_aa_04_CInt1 -i tst_mb_aa_04_CInt2");
           cmdList.add("indicator-create tst_mb_aa_04_div_CInt1_CInt2 -t correlate op=div -i tst_mb_aa_04_CInt1 -i tst_mb_aa_04_CInt2");
           cmdList.add("indicator-create tst_mb_aa_04_percent_CInt1_CInt2 -t correlate op=percent -i tst_mb_aa_04_CInt1 -i tst_mb_aa_04_CInt2");
           cmdList.add("indicator-create tst_mb_aa_04_add_CInt1_CInt2_CInt1_15 -t correlate op=add -i tst_mb_aa_04_CInt1 -i tst_mb_aa_04_CInt2 -i tst_mb_aa_04_CInt1 -i tst_C_15");
           cmdList.add("indicator-create tst_mb_aa_04_mul_CInt1_CInt2_CInt1_2 -t correlate op=mul -i tst_mb_aa_04_CInt1 -i tst_mb_aa_04_CInt2 -i tst_mb_aa_04_CInt1 -i tst_C_2");
           cmdList.add("indicator-create tst_mb_ab_01_VIncremented -t jmx target=tst_agent0 mbean=*:type=Basic,category=ab,name=mb_ab_01 attr=VIncremented test=true");
           cmdList.add("indicator-create tst_mb_ab_02_VIncremented -t jmx target=tst_agent0 mbean=*:type=Basic,category=ab,name=mb_ab_02 attr=VIncremented test=true");
           cmdList.add("indicator-create tst_mb_ab_xx_add_VIncremented -t correlate op=add -i tst_mb_ab_01_VIncremented -i tst_mb_ab_02_VIncremented");
           cmdList.add("indicator-create tst_mb_ab_01_CInt1 -t jmx target=tst_agent0 mbean=*:type=Basic,category=ab,name=mb_ab_01 attr=CInt1 test=true");
           cmdList.add("indicator-create tst_mb_ab_01_CInt2 -t jmx target=tst_agent0 mbean=*:type=Basic,category=ab,name=mb_ab_01 attr=CInt2 test=true");
           cmdList.add("indicator-create tst_mb_ab_02_CInt1 -t jmx target=tst_agent0 mbean=*:type=Basic,category=ab,name=mb_ab_02 attr=CInt1 test=true");
           cmdList.add("indicator-create tst_mb_ab_02_CInt2 -t jmx target=tst_agent0 mbean=*:type=Basic,category=ab,name=mb_ab_02 attr=CInt2 test=true");
           cmdList.add("indicator-create tst_mb_ab_xx_sub_CInt1 -t correlate op=sub -i tst_mb_ab_01_CInt1 -i tst_mb_ab_02_CInt1");
           cmdList.add("indicator-create tst_mb_ab_xx_mul_CInt1 -t correlate op=mul -i tst_mb_ab_01_CInt1 -i tst_mb_ab_02_CInt1");
           cmdList.add("indicator-create tst_mb_ab_xx_div_CInt1 -t correlate op=div -i tst_mb_ab_01_CInt1 -i tst_mb_ab_02_CInt1");
           cmdList.add("indicator-create tst_mb_ab_xx_percent_CInt1 -t correlate op=percent -i tst_mb_ab_01_CInt1 -i tst_mb_ab_02_CInt1");
           cmdList.add("indicator-create tst_mb_ac_01 -t jmx target=tst_agent0 mbean=*:type=Basic,category=ac,name=mb_ac_01 attr=CInt1,CInt2 test=true");
           cmdList.add("indicator-create tst_mb_ac_01_sum -t merge op=sum -i tst_mb_ac_01");
           cmdList.add("indicator-create tst_mb_ac_01_average -t merge op=average -i tst_mb_ac_01");
           cmdList.add("indicator-create tst_mb_ac_01_min -t merge op=min -i tst_mb_ac_01");
           cmdList.add("indicator-create tst_mb_ac_01_max -t merge op=max -i tst_mb_ac_01");
           cmdList.add("indicator-create tst_mb_ac_xx_CInt1 -t jmx target=tst_agent0 mbean=*:type=Basic,category=ac,* attr=CInt1 test=true");
           cmdList.add("indicator-create tst_mb_ac_xx_sum_CInt1 -t merge op=sum -i tst_mb_ac_xx_CInt1");
           cmdList.add("indicator-create tst_mb_ac_xx_average_CInt1 -t merge op=average -i tst_mb_ac_xx_CInt1");
           cmdList.add("indicator-create tst_mb_ac_xx_min_CInt1 -t merge op=min -i tst_mb_ac_xx_CInt1");
           cmdList.add("indicator-create tst_mb_ac_xx_max_CInt1 -t merge op=max -i tst_mb_ac_xx_CInt1");
           cmdList.add("indicator-create tst_mbdefault_target_unknown -t jmx target=tst_agent_unknown mbean=*:type=Basic,category=default,name=mbdefault attr=CInt1,CFloat1 test=true");
           cmdList.add("indicator-create tst_mb_aa_04_CFloat1 -t jmx target=tst_agent0 mbean=*:type=Basic,category=aa,name=mb_aa_04 attr=CFloat1 test=true");
           cmdList.add("indicator-create tst_mb_aa_04_CFloat2 -t jmx target=tst_agent0 mbean=*:type=Basic,category=aa,name=mb_aa_04 attr=CFloat2 test=true");
           cmdList.add("indicator-create tst_mb_aa_04_add_CFloat1_CFloat2 -t correlate op=add -i tst_mb_aa_04_CFloat1 -i tst_mb_aa_04_CFloat2");
           cmdList.add("indicator-create tst_mb_aa_04_sub_CFloat1_CFloat2 -t correlate op=sub -i tst_mb_aa_04_CFloat1 -i tst_mb_aa_04_CFloat2");
           cmdList.add("indicator-create tst_mb_aa_04_mul_CFloat1_CFloat2 -t correlate op=mul -i tst_mb_aa_04_CFloat1 -i tst_mb_aa_04_CFloat2");
           cmdList.add("indicator-create tst_mb_ac_xx_CFloatX -t jmx target=tst_agent0 mbean=*:type=Basic,category=ac,* attr=CFloat1,CFloat2 test=true");
           cmdList.add("indicator-create tst_mb_ac_xx_sum_CFloatX -t merge op=sum -i tst_mb_ac_xx_CFloatX");
           cmdList.add("indicator-create tst_mb_ac_xx_average_CFloatX -t merge op=average -i tst_mb_ac_xx_CFloatX");
           cmdList.add("indicator-create tst_mb_ac_xx_max_CFloatX -t merge op=max -i tst_mb_ac_xx_CFloatX");
           cmdList.add("indicator-create tst_mb_ac_xx_min_CFloatX -t merge op=min -i tst_mb_ac_xx_CFloatX");
           cmdList.add("indicator-create tst_mb_aa_05_CInt1 -t jmx target=tst_agent0 mbean=*:type=Basic,category=aa,name=mb_aa_05 attr=CInt1 test=true");
           cmdList.add("indicator-create tst_mb_aa_05_CInt2 -t jmx target=tst_agent0 mbean=*:type=Basic,category=aa,name=mb_aa_05 attr=CInt2 test=true");
           cmdList.add("indicator-create tst_mb_aa_05_add_CInt1_1 -t correlate op=add -i tst_mb_aa_05_CInt1 -i tst_C_1");
           cmdList.add("indicator-create tst_mb_aa_05_sub_CInt1_1 -t correlate op=sub -i tst_mb_aa_05_CInt1 -i tst_C_1");
           cmdList.add("indicator-create tst_mb_aa_05_delta_CInt1 -t derived op=delta -i tst_mb_aa_05_CInt1");
           cmdList.add("indicator-create tst_mb_aa_05_rate_CInt1 -t derived op=rate -i tst_mb_aa_05_CInt1");
           cmdList.add("indicator-create tst_mb_aa_05_total -t correlate op=add -i tst_mb_aa_05_add_CInt1_1 -i tst_mb_aa_05_sub_CInt1_1");
           cmdList.add("indicator-create tst_mb_aa_06_CIncrement -t jmx target=tst_agent0 mbean=*:type=Basic,category=aa,name=mb_aa_06 attr=CIncrement test=true");
           cmdList.add("indicator-create tst_mb_aa_06_VIncremented -t jmx target=tst_agent0 mbean=*:type=Basic,category=aa,name=mb_aa_06 attr=VIncremented test=true");
           cmdList.add("indicator-create tst_mb_aa_06_delta_VIncremented -t derived op=delta -i tst_mb_aa_06_VIncremented");
           cmdList.add("indicator-create tst_mb_bb_xx_CIncrement -t jmx target=tst_agent0 mbean=*:type=Basic,category=bb,* attr=CIncrement test=true");
           cmdList.add("indicator-create tst_mb_bb_xx_CAmplitude -t jmx target=tst_agent0 mbean=*:type=Basic,category=bb,* attr=CAmplitude test=true");
           cmdList.add("indicator-create tst_mb_bb_xx_CStep -t jmx target=tst_agent0 mbean=*:type=Basic,category=bb,* attr=CStep test=true");
           cmdList.add("indicator-create tst_mb_bb_xx_VPeriod -t jmx target=tst_agent0 mbean=*:type=Basic,category=bb,* attr=VPeriod test=true");
           cmdList.add("indicator-create tst_mb_bb_xx_VIncremented -t jmx target=tst_agent0 mbean=*:type=Basic,category=bb,* attr=VIncremented test=true");
           cmdList.add("indicator-create tst_mb_bb_xx_VSinusoidal -t jmx target=tst_agent0 mbean=*:type=Basic,category=bb,* attr=VSinusoidal test=true");
           cmdList.add("indicator-create tst_mb_bb_xx_delta_VIncremented -t derived op=delta -i tst_mb_bb_xx_VIncremented");
           cmdList.add("indicator-create tst_mb_bb_xx_rate_VIncremented -t derived op=rate -i tst_mb_bb_xx_VIncremented");
           cmdList.add("indicator-create tst_mb_bb_xx_delta_VSinusoidal -t derived op=delta -i tst_mb_bb_xx_VSinusoidal");
           cmdList.add("indicator-create tst_mb_bb_xx_rate_VSinusoidal -t derived op=rate -i tst_mb_bb_xx_VSinusoidal");
           cmdList.add("indicator-create tst_mb_bb_xx_VIncremented_per_VSinusoidal -t slope -i tst_mb_bb_xx_VIncremented -i tst_mb_bb_xx_VSinusoidal");
           cmdList.add("indicator-create tst_mb_bb_xx_CAmplitude_per_CStep -t slope -i tst_mb_bb_xx_CAmplitude -i tst_mb_bb_xx_CStep");
           cmdList.add("indicator-create tst_df_all -t df");
           cmdList.add("indicator-create tst_df_all_min -t merge op=min -i tst_df_all");
           cmdList.add("indicator-create tst_df_all_max -t merge op=max -i tst_df_all");
           cmdList.add("indicator-create tst_df_all_add_min_max -t correlate op=add -i tst_df_all_min -i tst_df_all_max");
           cmdList.add("indicator-create tst_df_all_mul_min_max -t correlate op=mul -i tst_df_all_min -i tst_df_all_max ");
           cmdList.add("probe-create ptst_mbdefault_all_attributes -start -p 3 -o tst_mbdefault_all_attributes -i tst_mbdefault_all_attributes");
           cmdList.add("probe-create ptst_mb_aa_01_delta -start -p 3 -o tst_mb_aa_01_delta -i tst_mb_aa_01_CIncrement -i tst_mb_aa_01_delta_VIncremented");
           cmdList.add("probe-create ptst_mb_aa_02 -start -p 3 -o tst_mb_aa_02_rate -i tst_mb_aa_02_CIncrement -i tst_mb_aa_02_rate_VIncremented");
           cmdList.add("probe-create ptst_mb_aa_03_slope -start -p 8 -o tst_mb_aa_03_slope -i tst_mb_aa_03 -i tst_mb_aa_03_slope_VIncremented_VSinusoidal");
           cmdList.add("probe-create ptst_mb_aa_04_add_CInt1_CInt2 -start -p 3 -o tst_mb_aa_04_add -i tst_mb_aa_04_CInt1 -i tst_mb_aa_04_CInt2 -i tst_mb_aa_04_add_CInt1_CInt2");
           cmdList.add("probe-create ptst_mb_aa_04_sub_CInt1_CInt2 -start -p 3 -o tst_mb_aa_04_sub -i tst_mb_aa_04_CInt1 -i tst_mb_aa_04_CInt2 -i tst_mb_aa_04_sub_CInt1_CInt2");
           cmdList.add("probe-create ptst_mb_aa_04_mul_CInt1_CInt2 -start -p 3 -o tst_mb_aa_04_mul -i tst_mb_aa_04_CInt1 -i tst_mb_aa_04_CInt2 -i tst_mb_aa_04_mul_CInt1_CInt2");
           cmdList.add("probe-create ptst_mb_aa_04_div_CInt1_CInt2 -start -p 3 -o tst_mb_aa_04_div -i tst_mb_aa_04_CInt1 -i tst_mb_aa_04_CInt2 -i tst_mb_aa_04_div_CInt1_CInt2");
           cmdList.add("probe-create ptst_mb_aa_04_percent_CInt1_CInt2 -start -p 3 -o tst_mb_aa_04_percent -i tst_mb_aa_04_CInt1 -i tst_mb_aa_04_CInt2 -i tst_mb_aa_04_percent_CInt1_CInt2");
           cmdList.add("probe-create ptst_mb_aa_04_add_complex -start -p 3 -o tst_mb_aa_04_add_complex -i tst_mb_aa_04_CInt1 -i tst_mb_aa_04_CInt2 -i tst_mb_aa_04_add_CInt1_CInt2_CInt1_15");
           cmdList.add("probe-create ptst_mb_aa_04_mul_complex -start -p 3 -o tst_mb_aa_04_mul_complex -i tst_mb_aa_04_CInt1 -i tst_mb_aa_04_CInt2 -i tst_mb_aa_04_mul_CInt1_CInt2_CInt1_2");
           cmdList.add("probe-create ptst_mb_ab_xx_add_VIncremented -start -p 3 -o tst_mb_ab_xx_correlate -i tst_mb_ab_xx_add_VIncremented");
           cmdList.add("probe-create ptst_mb_ab_xx_CInt1 -start -p 3 -o tst_mb_ab_xx_correlate -i tst_mb_ab_01_CInt1 -i tst_mb_ab_02_CInt1");
           cmdList.add("probe-create ptst_mb_ab_xx_sub_CInt1 -start -p 3 -o tst_mb_ab_xx_correlate -i tst_mb_ab_xx_sub_CInt1");
           cmdList.add("probe-create ptst_mb_ab_xx_mul_CInt1 -start -p 3 -o tst_mb_ab_xx_correlate -i tst_mb_ab_xx_mul_CInt1");
           cmdList.add("probe-create ptst_mb_ab_xx_div_CInt1 -start -p 3 -o tst_mb_ab_xx_correlate -i tst_mb_ab_xx_div_CInt1");
           cmdList.add("probe-create ptst_mb_ab_xx_percent_CInt1 -start -p 3 -o tst_mb_ab_xx_correlate -i tst_mb_ab_xx_percent_CInt1");
           cmdList.add("probe-create ptst_mb_ac_01 -start -p 3 -o tst_mb_ac_01_merge -i tst_mb_ac_01");
           cmdList.add("probe-create ptst_mb_ac_01_sum -start -p 3 -o tst_mb_ac_01_merge -i tst_mb_ac_01_sum");
           cmdList.add("probe-create ptst_mb_ac_01_min -start -p 3 -o tst_mb_ac_01_merge -i tst_mb_ac_01_min");
           cmdList.add("probe-create ptst_mb_ac_01_max -start -p 3 -o tst_mb_ac_01_merge -i tst_mb_ac_01_max");
           cmdList.add("probe-create ptst_mb_ac_xx_CInt1 -start -p 3 -o tst_mb_ac_xx_merge_one -i tst_mb_ac_xx_CInt1");
           cmdList.add("probe-create ptst_mb_ac_xx_sum_CInt1 -start -p 3 -o tst_mb_ac_xx_merge_one -i tst_mb_ac_xx_sum_CInt1");
           cmdList.add("probe-create ptst_mb_ac_xx_average_CInt1 -start -p 3 -o tst_mb_ac_xx_merge_one -i tst_mb_ac_xx_average_CInt1");
           cmdList.add("probe-create ptst_mb_ac_xx_min_CInt1 -start -p 3 -o tst_mb_ac_xx_merge_one -i tst_mb_ac_xx_min_CInt1");
           cmdList.add("probe-create ptst_mb_ac_xx_max_CInt1 -start -p 3 -o tst_mb_ac_xx_merge_one -i tst_mb_ac_xx_max_CInt1");
           cmdList.add("probe-create ptst_mbdefault_target_on_probe -start -p 3 -o tst_mbdefault_target_on_probe -target tst_agent0 -i tst_mbdefault_target_unknown");
           cmdList.add("probe-create ptst_mb_aa_04_add_CFloat1_CFloat2 -start -p 3 -o tst_mb_aa_04_add_float -i tst_mb_aa_04_CFloat1 -i tst_mb_aa_04_CFloat2 -i tst_mb_aa_04_add_CFloat1_CFloat2");
           cmdList.add("probe-create ptst_mb_aa_04_sub_CFloat1_CFloat2 -start -p 3 -o tst_mb_aa_04_sub_float -i tst_mb_aa_04_CFloat1 -i tst_mb_aa_04_CFloat2 -i tst_mb_aa_04_sub_CFloat1_CFloat2");
           cmdList.add("probe-create ptst_mb_aa_04_mul_CFloat1_CFloat2 -start -p 3 -o tst_mb_aa_04_mul_float -i tst_mb_aa_04_CFloat1 -i tst_mb_aa_04_CFloat2 -i tst_mb_aa_04_mul_CFloat1_CFloat2");
           cmdList.add("probe-create ptst_mb_ac_xx_aggreagte_CFloatX -start -p 3 -o tst_mb_ac_xx_merge_float -i tst_mb_ac_xx_CFloatX -i tst_mb_ac_xx_sum_CFloatX -i tst_mb_ac_xx_average_CFloatX -i tst_mb_ac_xx_max_CFloatX -i tst_mb_ac_xx_min_CFloatX");
           cmdList.add("probe-create ptst_mb_aa_05_BUG133_several_use_indicator -start -p 3 -o tst_mb_aa_05_BUG133_several_use_indicator -i tst_mb_aa_05_CInt1 -i tst_mb_aa_05_CInt2 -i tst_mb_aa_05_add_CInt1_1 -i tst_mb_aa_05_sub_CInt1_1 -i tst_mb_aa_05_delta_CInt1 -i tst_mb_aa_05_rate_CInt1");
           cmdList.add("probe-create ptst_mb_aa_05_BUG145_several_use_indicator -start -p 3 -o tst_mb_aa_05_BUG145_several_use_indicator -i tst_mb_aa_05_CInt1 -i tst_mb_aa_05_add_CInt1_1 -i tst_mb_aa_05_sub_CInt1_1 -i tst_mb_aa_05_total");
           cmdList.add("probe-create ptst_mb_aa_06_cache_several_use_indicator -start -p 3 -o tst_mb_aa_06_cache_several_use_indicator -i tst_mb_aa_06_CIncrement -i tst_mb_aa_06_VIncremented -i tst_mb_aa_06_VIncremented -i tst_mb_aa_06_delta_VIncremented -i tst_mb_aa_06_delta_VIncremented");
           cmdList.add("probe-create ptst_mb_bb_xx_delta_rate_slope -start -p 3 -o tst_mb_bb_xx_delta_rate_slope -i tst_mb_bb_xx_CIncrement -i tst_mb_bb_xx_CAmplitude -i tst_mb_bb_xx_CStep -i tst_mb_bb_xx_VPeriod -i tst_mb_bb_xx_VIncremented -i tst_mb_bb_xx_VSinusoidal -i tst_mb_bb_xx_delta_VIncremented -i tst_mb_bb_xx_rate_VIncremented -i tst_mb_bb_xx_delta_VSinusoidal -i tst_mb_bb_xx_rate_VSinusoidal");
           cmdList.add("probe-create ptst_df_all_several_use_indicator -start -p 3 -o tst_df_all_several_use_indicator -i tst_df_all -i tst_df_all_min -i tst_df_all_max -i tst_df_all_add_min_max -i tst_df_all_mul_min_max ");

           Runtime rt = Runtime.getRuntime();
           Process process;
           int pexit;

           for(String cmd: cmdList) {
               logger.info("-> " + cmd);
               process = rt.exec(cmdBegin + cmd);
               pexit = process.waitFor();
               if (pexit != 0) {
                   logger.info("      command execution ERROR");
                   // Assert.fail() not necessary because some tests will fail
               }
           }

       } catch (Exception e) {
           e.printStackTrace();
           Assert.fail("Error when creating indicators/probes", e);
       }
       logger.info("The indicators/probes have been successfully created via the JMX JProbe client");

       // Wait few mn to get the time to do some collects .... and than stop all the probes
       logger.info("Wait " + WAIT_COLLECTS_IN_SEC + " sec to get time to do some collects ...");
       Thread.sleep(WAIT_COLLECTS_IN_SEC*1000);
       getProxyMXBean().stopAllProbes();
   }

}
