package org.ow2.jasmine.probe.itests.dummymbeanservice;

import java.util.HashMap;
import java.util.Map;

public class Complex implements ComplexMXBean {

    private Person person;
    private StructOneField structOneField;
    
    public Complex(String firstName, String lastName, Sexe sexe, Address addr, int birth, Integer[] children) {
        this.person = new Person(firstName, lastName, sexe, addr, birth, children);
        this.structOneField = new StructOneField(firstName+" "+lastName);
    }
    public Person getPerson() {
        return this.person;
    }
    public StructOneField getStructOneField() {
        return this.structOneField;
    }
    public String[] getStringArray() {
        String[] sArray;
        sArray = new String[2];
        sArray[0] =person.getFirstName();
        sArray[1] =person.getLastName();
        return sArray;
    }
    public int[] getIntArray() {
        int[] intArray;
        intArray = new int[3];
        intArray[0] = person.getYearOfBirth();
        intArray[1] = person.getYearOfBirth() + 1000;
        intArray[2] = person.getYearOfBirth() + 2000;
        return intArray;
    }
    public long[] getLongArrayOneElt() {
        long[] longArray;
        longArray = new long[1];
        longArray[0] = person.getYearOfBirth() + 1000000;
        return longArray;
    }
    public Map<String, String> getTabularSimple() {
        HashMap<String, String> hm = new HashMap<String, String>();
        hm.put("firstName", person.getFirstName());
        hm.put("lastName", person.getLastName());
        return hm;
    }
    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("person       = " + getPerson() + "\n");
        b.append("                structOneField = '" + getStructOneField() + "',\n");
        b.append("                stringArray  = ");
        for (String elt : getStringArray()) {
            b.append(elt + ",");
        }
        b.append("\n");
        b.append("                intArray  = ");
        for (int elt : getIntArray()) {
            b.append(elt + ",");
        }
        b.append("\n");
        b.append("                tabularSimple = " + getTabularSimple());
        return b.toString();
    }

}
