/**
 * JASMINe
 * Copyright (C) 2010 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id$
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.probe;

import java.util.HashMap;
import java.util.Map;

/**
 * Provides a JASMINe target definition elements
 * @author danesa
 */
public class JasmineTarget extends JasmineObject {

    /**
     *  State Management.
     *  This information should be set only on the server side.
     */
    private int state = TARGET_UNKNOWN;

    public static final int TARGET_UNKNOWN = 0;
    public static final int TARGET_RUNNING = 1;
    public static final int TARGET_FAILED = 2;

    /**
     * default constructor
     */
    public JasmineTarget() {
        super();
        // type of Target: today always jmx.
        type = "jmx";
    }


    public int getState() {
        return this.state;
    }

    public void setState(int state) {
        this.state = state;
    }

    /**
     * @deprecated
     * @return
     */
    public String getUrl() {
        return properties.get("url");
    }

    /**
     * @deprecated
     */
    public void setUrl(String url) {
        properties.put("url", url);
    }

    /**
     * Build a full description of this object.
     * @return string representation of the object.
     */
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("JasmineTarget " + name);
        for (String key : properties.keySet()) {
            buffer.append("\n> " + key + " = " + properties.get(key));
        }
        return buffer.toString();
    }

    /**
     * Build a single line description of this object.
     * @return
     */
    public String toLine()  {
        String formattedName = (name + "                    ").substring(0, 20);
        if (properties.get("user") != null) {
            formattedName += "secured ";
        } else {
            formattedName += "        ";
        }
        return formattedName + properties.get("url");
    }
    /**
     * Indicates whether some other object is "equal to" this one.
     * @param obj The other object to compare
     * @return true if both objects are the same.
     */
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (! (obj instanceof JasmineTarget)) {
            return false;
        }
        JasmineTarget other = (JasmineTarget) obj;
        if (!name.equals(other.getName())) {
            return false;
        }
        if (!type.equals(other.getType())) {
            return false;
        }

        if (properties.size() != other.properties.size()) {
            return false;
        }
        for (String key : properties.keySet()) {
            if (!other.properties.containsKey(key)) {
                return false;
            }
            String value = properties.get(key);
            if (value != null) {
                if (!value.equals(other.properties.get(key))) {
                    return false;
                }
            } else {
                if (other.properties.get(key) != null) {
                    return false;
                }
            }
        }
        return true;
    }

}
