/**
 * JASMINe
 * Copyright (C) 2012 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id$
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.probe.outers.rest;

import java.util.Map;

import org.ow2.jasmine.probe.JasmineOutput;
import org.ow2.jasmine.probe.JasmineProbeResult;
import org.ow2.jasmine.probe.outers.JOuter;
import org.ow2.jasmine.probe.rest.Task;

/**
 * Outer implementation for ...
 */
public class JRestOuter extends JOuter {

    private Task task = null;


    /**
     * Constructor
     * @param output definition
     */
    public JRestOuter(JasmineOutput output) {
        super(output);
        // specific part of JasmineOutput (property list)
        Map<String, String> props = output.getProperties();
        logger.debug("rest outer created with taskId {0}", props.get("taskId"));
    }

    /**
     * Publish data on this Output
     * @param result data to publish
     */
    public void processData(JasmineProbeResult result) {
        if (task != null) {
          task.setLastResult(result);
        }
    }

    protected void setTask(Task task) {
        logger.debug("Task set");
        this.task = task;
    }

}
