/**
 * JASMINe
 * Copyright (C) 2012 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id$
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.probe.rest;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/**
 * Root resource class for data tasks management.
 * Contains methods to treat HTTP requests on "data" task resources.
 * @author danesa
 *
 */
@Path("/data")
public interface DataTasks {

    public final String RESOURCE_NAME = "data";

    /**
     * logger used for data task management
     */
    public static final Log logger = LogFactory.getLog(DataTasks.class);

    /**
     * Process HTTP GET requests having /data URI
     * It lists all data tasks.
     * @return response containing the existent data task ids
     */
    @GET
    @Produces(MediaType.APPLICATION_XML)
    Response getDataTasks(@Context UriInfo ui);

    /**
     * Process HTTP GET requests having /data/{id} URI
     * @param id data task id
     * @return response
     */
    @GET
    @Path("/{id}")
    @Produces(MediaType.APPLICATION_XML)
    Response getData(@PathParam("id") String id);

}
