package org.ow2.jasmine.probe.rest.impl;

import java.util.ArrayList;
import java.util.List;

import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;

import org.ow2.jasmine.probe.JasmineCollectorInfo;
import org.ow2.jasmine.probe.JasmineProbeManager;
import org.ow2.jasmine.probe.JasminePropertyInfo;
import org.ow2.jasmine.probe.api.generated.CollectorInfoType;
import org.ow2.jasmine.probe.api.generated.PropInfoType;
import org.ow2.jasmine.probe.api.generated.ResourceType;
import org.ow2.jasmine.probe.rest.IndicatorTypes;

public class JIndicatorTypes implements IndicatorTypes {

    private JasmineProbeManager jpManager = null;

    public JIndicatorTypes(JasmineProbeManager jpManager) {
        this.jpManager = jpManager;
    }

    @Override
    public Response getIndicatorTypes() {
        List<JAXBElement<ResourceType>> elementsList = new ArrayList<JAXBElement<ResourceType>>();

        for (String type : jpManager.getIndicatorTypes()) {
            ResourceType typeElement = new ResourceType();
            typeElement.setType(type);

            QName qname  = new QName("org.ow2.jasmine.probe:probe-config", "indicatorType");
            JAXBElement xmlElement = new JAXBElement<ResourceType>(qname, ResourceType.class, typeElement);
            elementsList.add(xmlElement);
        }

        return Response
                        .status(Response.Status.OK)
                        .entity(new GenericEntity<List<JAXBElement<ResourceType>>>(elementsList) {})
                        .type(MediaType.APPLICATION_XML_TYPE)
                        .build();
    }

    public Response getIndicatorTypeProps(String type) {
        List<JAXBElement<PropInfoType>> elementsList = new ArrayList<JAXBElement<PropInfoType>>();

        JasmineCollectorInfo info = jpManager.getIndicatorTypeInfo(type);
        List<JasminePropertyInfo> propertyInfos = info.getPropertyInfos();
        for (JasminePropertyInfo propertyInfo : propertyInfos) {
            PropInfoType propInfoElement = new PropInfoType();
            if (propertyInfo.isRequired()) {
                propInfoElement.setRequired("true");
            } else {
                propInfoElement.setRequired("false");
            }
            propInfoElement.setDescription(propertyInfo.getDescription());
            propInfoElement.setName(propertyInfo.getName());

            QName qname  = new QName("org.ow2.jasmine.probe:probe-config", "indicatorProperty");
            JAXBElement xmlElement = new JAXBElement<PropInfoType>(qname, PropInfoType.class, propInfoElement);
            elementsList.add(xmlElement);
        }

        return Response
                        .status(Response.Status.OK)
                        .entity(new GenericEntity<List<JAXBElement<PropInfoType>>>(elementsList) {})
                        .type(MediaType.APPLICATION_XML_TYPE)
                        .build();
    }

    @Override
    public Response getIndicatorTypeInfo(String type) {
        CollectorInfoType infoElement = new CollectorInfoType();

        JasmineCollectorInfo info = jpManager.getIndicatorTypeInfo(type);
        infoElement.setShortDesc(info.getShortDesc());
        infoElement.setLongDesc(info.getLongDesc());
        infoElement.setSourceDesc(info.getSourceDesc());
        int sMin = info.getSourceMin();
        int sMax = info.getSourceMax();
        if (sMin > 0) {
            if (sMin == sMax) {
                if (sMin == 1) {
                    infoElement.setSourcesNumber(sMin + " source is required");
                } else {
                    infoElement.setSourcesNumber(sMin + " sources are required");
                }
            } else {
                infoElement.setSourcesNumber("Minimum " + sMin + " sources required");
            }
        }

        QName name  = new QName("org.ow2.jasmine.probe:probe-config", "indicatorInfo");
        JAXBElement xmlElement = new JAXBElement<CollectorInfoType>(name, CollectorInfoType.class, infoElement);

        return Response
                        .status(Response.Status.OK)
                        .entity(xmlElement)
                        .type(MediaType.APPLICATION_XML_TYPE)
                        .build();
    }
}
