/**
 * JASMINe
 * Copyright (C) 2013 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 */

package org.ow2.jasmine.probe.shell;

import org.apache.felix.gogo.commands.Action;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.HandlerDeclaration;
import org.apache.felix.ipojo.annotations.Requires;
import org.apache.felix.service.command.CommandSession;
import org.ow2.jasmine.probe.JasmineOutput;
import org.ow2.jasmine.probe.JasmineProbeManager;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Shell command: output-create
 *
 * @author durieuxp
 */
@Component
@Command(name = "output-create",
        scope = "jasmine",
        description = "Create a JASMINe output")
@HandlerDeclaration("<sh:command xmlns:sh='org.ow2.shelbie'/>")
public class OutputCreate implements Action {

    @Requires
    JasmineProbeManager probeManager = null;

    @Argument(index = 0, name = "name", description = "Output Name", required = true, multiValued = false)
    private String name;

    @Option(name = "-t", aliases = "--type", description = "Output Type", required = true, multiValued = false)
    private String type;

    @Option(name = "-d", aliases = "--define", description = "Specific output properties given in key=value format", required = false, multiValued = true)
    private List<String> params;

    protected static Log logger = LogFactory.getLog(Util.class);

    public Object execute(CommandSession commandSession) {

        logger.debug("");

        try {
            // Get and check the specific properties
            Map<String, String> properties = new HashMap<String, String>();
            if (params != null) {
                for (String param : params) {
                    if (Util.validParam(param)) {
                        int indexEqual = param.indexOf("=");
                        String paramName = param.substring(0, indexEqual);
                        String paramValue = param.substring(indexEqual + 1, param.length());
                        properties.put(paramName, paramValue);
                    } else {
                        logger.error("output-create " + name + " failed");
                        // wrong parameter format
                        logger.error("Wrong properties format for " + param);
                        logger.error("Expected format is paramName=paramValue");
                        return null;
                    }
                }
            }
            // Create the JasmineOutput
            JasmineOutput n = new JasmineOutput();
            n.setName(name);
            n.setType(type);
            n.setProperties(properties);
            probeManager.createOutput(n);
            logger.info("output-create " + name + " successful");
        } catch (Exception e) {
            logger.error("output-create " + name + " failed", e);
        }
        return null;
    }


}