/**
 * JASMINe
 * Copyright (C) 2011 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: JasmineOutput.java 8643 2011-07-25 12:19:35Z danesa $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.probe;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Map.Entry;

/**
 * Used to define OUTPUT arguments for a JASMINe probes.
 *  @author durieuxp
 */
public class JasmineOutput {
    /**
     * Output name (output identifier).
     */
    private String name = null;

    /**
     * type of Output: should identify the OuterService to be used.
     */
    private String type = null;

    /**
     * Type specific parameters
     */
    private Map<String, String> properties = new HashMap<String, String>();

    public Map<String, String> getProperties() {
        return properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    /**
     * Indicates whether some other object is "equal to" this one.
     * @param obj The other object to compare
     * @return true if both objects are the same.
     */
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (! (obj instanceof JasmineOutput)) {
            return false;
        }
        JasmineOutput other = (JasmineOutput) obj;
        return other.getName().equals(name);
    }

    /**
     * Returns a hash code value for the object.
     * @return hashcode value
     */
    public int hashCode() {
        return name == null ? 0 : name.length();
    }

    /**
     * @return string representation of the object.
     */
    public String toString() {
        String indicatorString = "Output " + name + " has type " + type;
        if (properties.isEmpty()) {
            indicatorString = indicatorString + "\n";
        } else {
            indicatorString = indicatorString + " and properties: \n";
        }
        Set<Entry<String, String>> props = properties.entrySet();
        for (Entry<String, String> prop : props) {
            String propString = "\t " + prop.getKey() + " = " + prop.getValue() + "\n";
            indicatorString  = indicatorString + propString;
        }
        return indicatorString;
    }

}

