/**
 * JASMINe
 * Copyright (C) 2011 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: JasmineProbe.java 8615 2011-07-21 13:56:21Z danesa $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.probe;

import java.util.List;

/**
 * JASMINe Probe definition.
 * Also contains state information and probe identifier.
 * @author durieuxp
 */
public class JasmineProbe {

    /**
     * Probe identifier. Can be provided by the JASMINe Probe Manager.
     */
    private String id;

    /**
     *  Probe outputs.
     */
    private List<String> outputList;

    /**
     * List of Indicators
     */
    private List<String> indicatorList;

    /**
     * List of default targets applied to indicators when
     * they do not have a target already defined.
     * This list will be empty, most of the time.
     */
    private List<String> targetList;

    /**
     * Status Management
     * The state is kept here because it must be returned to the final user.
     */
    private int status;
    public static final int PROBE_STOPPED = 0;
    public static final int PROBE_STARTED = 1;
    public static final int PROBE_RUNNING = 2;
    public static final int PROBE_FAILED  = 3;
    public static final int PROBE_TOSTART = 4;

    /**
     * error message in case of PROBE_FAILED
     * must be returned to the final user.
     */
    private String error;

    /**
     * Probe execution period in seconds.
     */
    private int period = 10;

    /**
     * default constructor
     */
    public JasmineProbe() {
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public int getPeriod() {
        return period;
    }

    public void setPeriod(int period) {
        this.period = period;
    }

    public String getError() {
        return error;
    }

    public void setError(String mess) {
        this.error = mess;
    }

    public List<String> getOutputList() {
        return outputList;
    }

    public void setOutputList(List<String> outputList) {
        this.outputList = outputList;
    }

    public List<String> getIndicatorList() {
        return indicatorList;
    }

    public void setIndicatorList(List<String> indicatorList) {
        this.indicatorList = indicatorList;
    }

    public int getStatus() {
        return status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public List<String> getTargetList() {
        return targetList;
    }

    public void setTargetList(List<String> targetList) {
        this.targetList = targetList;
    }

    public String toString() {
        String probeString = "Probe " + id + " :\n";
        // get targets
        String targets = null;
        if (targetList != null && !targetList.isEmpty()) {
            targets = "\t targets: ";
            for (String target : targetList) {
                targets = targets + target + " ";
            }
            probeString = probeString + targets;
        }
        // get indicators
        String indicators = null;
        if (indicatorList != null && !indicatorList.isEmpty()) {
            indicators = "\t indicators : ";
            for (String indicator : indicatorList) {
                indicators = indicators + indicator + " ";
            }
            probeString = probeString + indicators;
        }
        // get outputs
        String outputs = null;
        if (outputList != null && !outputList.isEmpty()) {
            outputs = "\t outputs : ";
            for (String output : outputList) {
                outputs = outputs + output + " ";
            }
            probeString = probeString + outputs;
        }
        return probeString;
    }
}
