/**
 * JASMINe
 * Copyright (C) 2011 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: JasmineAggregateService.java 8597 2011-07-21 08:18:00Z danesa $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.probe.collector;

import org.ow2.jasmine.probe.JasmineIndicValue;

/**
 * Service that do aggregate from source values to a result value
 * @author danesa
 *
 */
public interface JasmineAggregateService {

    /**
     *
     * @param source Contains values to be aggregated
     * @return result value
     */
    JasmineIndicValue aggregate(JasmineIndicValue source);

}
