/**
 * JASMINe
 * Copyright (C) 2011 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: JasmineOuterService.java 8360 2011-06-21 08:54:20Z durieuxp $
 * --------------------------------------------------------------------------
 */

package org.ow2.jasmine.probe.outer;

import org.ow2.jasmine.probe.JasmineOutput;
import org.ow2.jasmine.probe.JasminePropertyInfo;

import java.util.List;

/**
 * This interface is implemented by all the OuterServices
 * @author durieuxp
 */
public interface JasmineOuterService {

    /**
     * Get the Outer for this JasmineOutput VO
     * Create it if does not exist yet.
     * @param jasmineOutput VO
     * @return the Outer
     */
    JasmineOuter getOuter(JasmineOutput jasmineOutput) throws JasmineOuterException;

    /**
     * Retrieve the description of all specific properties hidden in JasmineOutput
     * Return a List of all properties with their description
     * @return  a List of property descriptions
     */
    List<JasminePropertyInfo> getPropertiesInfo();
}
