/**
 * JASMINe
 * Copyright (C) 2011 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: ProbeManager.java 8598 2011-07-21 08:20:01Z danesa $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.probe.probemanager;

import java.util.List;

import org.ow2.jasmine.probe.JasmineProbeException;
import org.ow2.jasmine.probe.JasmineTarget;
import org.ow2.jasmine.probe.collector.JasmineAggregateService;
import org.ow2.jasmine.probe.collector.JasmineCollector;
/**
 * Interface used by the JasmineProbe optional services.
 * @author danesa
 */
public interface ProbeManager {

    /**
     * Get a Collector by its Indicator name
     * @param indicator indicator name
     * @param period the period of the probe using the indicator
     * @param probeid
     * @return The collector corresponding to an indicator and a probe
     */
    JasmineCollector getCollector(String indicator, int period, String probeid) throws JasmineProbeException;

    /**
     * Get the name of aggregate functions provided by AggregateServices.
     * @return
     */
    List<String> getAggregateFuntions();

    /**
     * Get the AggregateServices corresponding to an aggregate function.
     * @param key aggregate function name
     * @return the corresponding AggregateServices
     */
    JasmineAggregateService getAggregate(String key);

    /**
     * Get a JasmineTarget by its name
     * @param name
     * @return JasmineTarget definition
     */
    JasmineTarget getTarget(String name);
}
