/**
 * JASMINe
 * Copyright (C) 2011 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: JasmineSingleResult.java 8846 2011-09-13 08:09:18Z danesa $
 * --------------------------------------------------------------------------
 */

package org.ow2.jasmine.probe;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;

/**
 * This class represents a single result value.
 * Instances of this class should be embedded in a JasmineIndicatorValue which may hold 1 or more
 * of these basic objetcs (indicators may be composite or multiple)
 * @author durieuxp
 */
public abstract class JasmineSingleResult implements Serializable {
    /**
     * Name representing this value
     */
    private String name;

    /**
     * Timestamp of the measure
     */
    private long timestamp;

    /**
     * List of properties associated to this value.
     * Their name depend on the Collector type.
     */
    private HashMap<String, String> properties;

    /**
     * Constructor
     */
    public JasmineSingleResult() {
        properties = new HashMap<String, String>();
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public long getTimestamp() {
        return timestamp;
    }

    public Date getDate() {
        return new Date(timestamp);
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public HashMap<String, String> getProperties() {
        return properties;
    }

    public void setProperties(HashMap<String, String> properties) {
        this.properties = properties;
    }

    public void addProperty(String key, String value) {
        this.properties.put(key, value);
    }

    public abstract Object getValue();

    public abstract void setValue(Object value);

}
