/**
 * JASMINe
 * Copyright (C) 2010 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: JasmineTarget.java 8843 2011-09-12 11:56:13Z durieuxp $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.probe;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/**
 * Provides a JASMINe target definition elements
 * @author danesa
 */
public class JasmineTarget {

    /**
     * Target name.
     */
    private String name = null;

    /**
     * Url of the target.
     * May have different format, depending on the type of the Collector.
     */
    private String url;

    /**
     * properties specific to the type of Collector used.
     */
    private Map<String, String> properties = new HashMap<String, String>();

    /**
     * default constructor
     * @return
     */
    public JasmineTarget() {
    }

    public String getName() {
        return name;
    }
    public void setName(String name) {
        this.name = name;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Map<String, String> getProperties() {
        return properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    /**
     * @return string representation of the object.
     */
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("JasmineTarget " + name);
        buffer.append("\n> url : " + url);
        for (String key : properties.keySet()) {
            buffer.append("\n> " + key + " = " + properties.get(key));
        }
        return buffer.toString();
    }
}
