/**
 * JASMINe
 * Copyright (C) 2011 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: JasmineProbeManager.java 8946 2011-09-20 07:03:51Z durieuxp $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.probe;

import java.util.Collection;
import java.util.Set;

/**
 * Interface for JASMINe Probe Manager.
 * Most of operations are inherited as part of the MXBean interface.
 * Are described here only operations not already present in the MXBean
 * @author durieuxp
 */
public interface JasmineProbeManager extends JProbeManagerMXBean {

    /**
     * Register a ProbeListener in order to be notified by probe state changes.
     * Maybe other events will be considered...
     * @param listener object that treats the probe state change
     */
    void addProbeListener(JasmineProbeListener listener);

}

